/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.api.TextFrameSender;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.impl.AbstractSender;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.TextWriter;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.xnio.channels.StreamSinkChannel;

class DefaultTextFrameSender
extends AbstractSender
implements TextFrameSender {
    public DefaultTextFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected WebSocketFrameType type() {
        return WebSocketFrameType.TEXT;
    }

    @Override
    public void sendText(CharSequence payload, SendCallback callback) {
        try {
            ByteBuffer buffer = WebSocketUtils.fromUtf8String(payload);
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(buffer.remaining()));
            StreamSinkChannelUtils.send(sink, buffer, callback);
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
        }
    }

    @Override
    public void sendText(CharSequence payload) throws IOException {
        this.checkBlockingAllowed();
        ByteBuffer buffer = WebSocketUtils.fromUtf8String(payload);
        StreamSinkChannel sink = this.createSink(buffer.remaining());
        StreamSinkChannelUtils.send(sink, buffer);
    }

    @Override
    public Writer sendText(long payloadSize) throws IOException {
        this.checkBlockingAllowed();
        return new TextWriter(this.session.getChannel(), this.createSink(payloadSize));
    }
}

