/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.client.HttpClientCallback;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.version13.WebSocket13Channel;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pool;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSourceChannel;

public class WebSocket13ClientHandshake
extends WebSocketClientHandshake {
    public static final String MAGIC_NUMBER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final AttachmentKey<String> KEY = AttachmentKey.create(String.class);

    public WebSocket13ClientHandshake(URI url) {
        super(url);
    }

    @Override
    public WebSocketChannel createChannel(ConnectedStreamChannel channel, String wsUri, Pool<ByteBuffer> bufferPool) {
        return new WebSocket13Channel(channel, bufferPool, wsUri, Collections.emptySet(), true, false);
    }

    @Override
    public void setupRequest(HttpClientRequest request) {
        request.getRequestHeaders().put(Headers.UPGRADE, "websocket");
        request.getRequestHeaders().put(Headers.CONNECTION, "upgrade");
        String key = this.createSecKey();
        request.getConnection().putAttachment(KEY, key);
        request.getRequestHeaders().put(Headers.SEC_WEB_SOCKET_KEY, key);
        request.getRequestHeaders().put(Headers.SEC_WEB_SOCKET_VERSION, this.getVersion().toHttpHeaderValue());
    }

    protected String createSecKey() {
        SecureRandom random = new SecureRandom();
        byte[] data = new byte[16];
        for (int i = 0; i < 4; ++i) {
            int val = random.nextInt();
            data[i * 4] = (byte)val;
            data[i * 4 + 1] = (byte)(val >> 8 & 0xFF);
            data[i * 4 + 2] = (byte)(val >> 16 & 0xFF);
            data[i * 4 + 3] = (byte)(val >> 24 & 0xFF);
        }
        return FlexBase64.encodeString(data, false);
    }

    @Override
    public void verifyResponse(final URI uri, HttpClientResponse response, final HttpClientConnection connection, final HttpClientCallback<WebSocketChannel> callback) throws IOException {
        String upgrade = response.getResponseHeaders().getFirst(Headers.UPGRADE);
        if (upgrade == null || !upgrade.toLowerCase().trim().equals("websocket")) {
            throw WebSocketMessages.MESSAGES.noWebSocketUpgradeHeader();
        }
        String connHeader = response.getResponseHeaders().getFirst(Headers.CONNECTION);
        if (connHeader == null || !connHeader.toLowerCase().trim().equals("upgrade")) {
            throw WebSocketMessages.MESSAGES.noWebSocketConnectionHeader();
        }
        String acceptKey = response.getResponseHeaders().getFirst(Headers.SEC_WEB_SOCKET_ACCEPT);
        String sentKey = connection.getAttachment(KEY);
        String dKey = this.solve(sentKey);
        if (!dKey.equals(acceptKey)) {
            throw WebSocketMessages.MESSAGES.webSocketAcceptKeyMismatch(dKey, acceptKey);
        }
        StreamSourceChannel responseChannel = response.readReplyBody();
        try {
            long read;
            do {
                if ((read = Channels.drain((StreamSourceChannel)responseChannel, (long)Long.MAX_VALUE)) != 0L) continue;
                responseChannel.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<StreamSourceChannel>(){

                    public void handleEvent(StreamSourceChannel channel) {
                        WebSocket13ClientHandshake.this.handleUpgrade(uri, connection, callback);
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                    public void handleException(StreamSourceChannel channel, IOException e) {
                        callback.failed(e);
                    }
                }));
                responseChannel.resumeReads();
                return;
            } while (read != -1L);
        }
        catch (IOException e) {
            callback.failed(e);
        }
        this.handleUpgrade(uri, connection, callback);
    }

    private void handleUpgrade(URI uri, HttpClientConnection connection, HttpClientCallback<WebSocketChannel> callback) {
        try {
            ConnectedStreamChannel channel = connection.performUpgrade();
            callback.completed(new WebSocket13Channel(channel, connection.getBufferPool(), uri.toString(), Collections.emptySet(), true, false));
        }
        catch (IOException e) {
            callback.failed(e);
        }
    }

    protected final String solve(String nonceBase64) {
        try {
            String concat = nonceBase64 + MAGIC_NUMBER;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes(WebSocketUtils.UTF_8));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString(bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public WebSocketVersion getVersion() {
        return WebSocketVersion.V13;
    }
}

