/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class ChunkedResponseTrailersTestCase {
    private static final String MESSAGE = "My HTTP Request!";
    private static volatile String message;
    private static volatile HttpServerConnection connection;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (connection == null) {
                        connection = exchange.getConnection();
                    } else if (!DefaultServer.isAjp() && connection.getChannel() != exchange.getConnection().getChannel()) {
                        OutputStream outputStream = exchange.getOutputStream();
                        outputStream.write("Connection not persistent".getBytes());
                        outputStream.close();
                        return;
                    }
                    HeaderMap trailers = new HeaderMap();
                    exchange.putAttachment(ChunkedStreamSinkConduit.TRAILERS, (Object)trailers);
                    trailers.put(HttpString.tryFromString((String)"foo"), "fooVal");
                    trailers.put(HttpString.tryFromString((String)"bar"), "barVal");
                    new StringWriteChannelListener(message).setup(exchange.getResponseChannel());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpRequest() throws Exception {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        final AtomicReference stream = new AtomicReference();
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws IOException {
                InputStream instream;
                HttpEntity entity = response.getEntity();
                if (entity != null && (instream = entity.getContent()) instanceof ChunkedInputStream) {
                    stream.set((ChunkedInputStream)instream);
                }
            }
        });
        try {
            ChunkedResponseTrailersTestCase.generateMessage(1);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            Header[] footers = ((ChunkedInputStream)stream.get()).getFooters();
            Assert.assertEquals((long)2L, (long)footers.length);
            for (Header header : footers) {
                if (header.getName().equals("foo")) {
                    Assert.assertEquals((Object)"fooVal", (Object)header.getValue());
                    continue;
                }
                if (header.getName().equals("bar")) {
                    Assert.assertEquals((Object)"barVal", (Object)header.getValue());
                    continue;
                }
                Assert.fail((String)("Unknown header" + header));
            }
            ChunkedResponseTrailersTestCase.generateMessage(1000);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            footers = ((ChunkedInputStream)stream.get()).getFooters();
            Assert.assertEquals((long)2L, (long)footers.length);
            for (Header header : footers) {
                if (header.getName().equals("foo")) {
                    Assert.assertEquals((Object)"fooVal", (Object)header.getValue());
                    continue;
                }
                if (header.getName().equals("bar")) {
                    Assert.assertEquals((Object)"barVal", (Object)header.getValue());
                    continue;
                }
                Assert.fail((String)("Unknown header" + header));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static void generateMessage(int repetitions) {
        StringBuilder builder = new StringBuilder(repetitions * MESSAGE.length());
        for (int i = 0; i < repetitions; ++i) {
            builder.append(MESSAGE);
        }
        message = builder.toString();
    }
}

