/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class InMemorySessionTestCase {
    public static final String COUNT = "count";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void inMemorySessionTest() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        CookieHandler cookieHandler = new CookieHandler();
        try {
            final SessionCookieConfig sessionConfig = new SessionCookieConfig();
            SessionAttachmentHandler handler = new SessionAttachmentHandler((SessionManager)new InMemorySessionManager(), (SessionConfig)sessionConfig);
            handler.setNext(new HttpHandler(){

                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                    Session session = manager.getSession(exchange, (SessionConfig)sessionConfig);
                    if (session == null) {
                        session = manager.createSession(exchange, (SessionConfig)sessionConfig);
                        session.setAttribute(InMemorySessionTestCase.COUNT, (Object)0);
                    }
                    Integer count = (Integer)session.getAttribute(InMemorySessionTestCase.COUNT);
                    exchange.getResponseHeaders().add(new HttpString(InMemorySessionTestCase.COUNT), count.toString());
                    count = count + 1;
                    session.setAttribute(InMemorySessionTestCase.COUNT, (Object)count);
                    HttpHandlers.executeHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, (HttpServerExchange)exchange);
                }
            });
            cookieHandler.setNext((HttpHandler)handler);
            DefaultServer.setRootHandler((HttpHandler)cookieHandler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

