/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.protocol.version00.WebSocket00BinaryFrameSourceChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import io.undertow.websockets.utils.StreamSourceChannelAdapter;
import io.undertow.websockets.utils.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class WebSocket00BinaryFrameSourceChannelTest {
    private static final byte[] TEXT_BYTES = "Text".getBytes(WebSocketUtils.UTF_8);
    private static final byte[] SOURCE_BYTES = new byte[6];

    @Test
    public void testReadWithBigBuffer() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(SOURCE_BYTES)));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00BinaryFrameSourceChannel channel = new WebSocket00BinaryFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, (WebSocketChannel)mockChannel, (long)TEXT_BYTES.length);
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        int read = channel.read(readBuffer);
        Assert.assertEquals((long)4L, (long)read);
        readBuffer.flip();
        Assert.assertEquals((long)4L, (long)readBuffer.remaining());
        Assert.assertArrayEquals((byte[])TEXT_BYTES, (byte[])TestUtils.readableBytes(readBuffer));
        read = channel.read(readBuffer);
        Assert.assertEquals((long)-1L, (long)read);
        readBuffer.clear();
        Assert.assertEquals((long)2L, (long)pch.read(readBuffer));
        readBuffer.flip();
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])TestUtils.readableBytes(readBuffer));
        Assert.assertEquals((long)-1L, (long)pch.read(readBuffer));
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testReadWithSmallBuffer() throws IOException {
        ByteBuffer complete = ByteBuffer.allocate(TEXT_BYTES.length);
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(SOURCE_BYTES)));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00BinaryFrameSourceChannel channel = new WebSocket00BinaryFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, (WebSocketChannel)mockChannel, (long)TEXT_BYTES.length);
        ByteBuffer readBuffer = ByteBuffer.allocate(2);
        int read = channel.read(readBuffer);
        Assert.assertEquals((long)2L, (long)read);
        readBuffer.flip();
        Assert.assertEquals((long)2L, (long)readBuffer.remaining());
        complete.put(readBuffer);
        read = channel.read(readBuffer);
        Assert.assertEquals((long)0L, (long)read);
        readBuffer.clear();
        read = channel.read(readBuffer);
        Assert.assertEquals((long)2L, (long)read);
        readBuffer.flip();
        Assert.assertEquals((long)2L, (long)readBuffer.remaining());
        complete.put(readBuffer);
        complete.flip();
        Assert.assertArrayEquals((byte[])TEXT_BYTES, (byte[])TestUtils.readableBytes(complete));
        readBuffer.clear();
        read = channel.read(readBuffer);
        Assert.assertEquals((long)-1L, (long)read);
        readBuffer.clear();
        Assert.assertEquals((long)2L, (long)pch.read(readBuffer));
        readBuffer.flip();
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])TestUtils.readableBytes(readBuffer));
        Assert.assertEquals((long)-1L, (long)pch.read(readBuffer));
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testReadWithSmallBuffer2() throws IOException {
        ByteBuffer complete = ByteBuffer.allocate(TEXT_BYTES.length);
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(SOURCE_BYTES)));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        WebSocket00BinaryFrameSourceChannel channel = new WebSocket00BinaryFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, (WebSocketChannel)mockChannel, (long)TEXT_BYTES.length);
        ByteBuffer readBuffer = ByteBuffer.allocate(3);
        int read = channel.read(readBuffer);
        Assert.assertEquals((long)3L, (long)read);
        readBuffer.flip();
        Assert.assertEquals((long)3L, (long)readBuffer.remaining());
        complete.put(readBuffer);
        read = channel.read(readBuffer);
        Assert.assertEquals((long)0L, (long)read);
        readBuffer.clear();
        read = channel.read(readBuffer);
        Assert.assertEquals((long)1L, (long)read);
        readBuffer.flip();
        Assert.assertEquals((long)1L, (long)readBuffer.remaining());
        complete.put(readBuffer);
        complete.flip();
        Assert.assertArrayEquals((byte[])TEXT_BYTES, (byte[])TestUtils.readableBytes(complete));
        readBuffer.clear();
        read = channel.read(readBuffer);
        Assert.assertEquals((long)-1L, (long)read);
        readBuffer.clear();
        Assert.assertEquals((long)2L, (long)pch.read(readBuffer));
        readBuffer.flip();
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])TestUtils.readableBytes(readBuffer));
        Assert.assertEquals((long)-1L, (long)pch.read(readBuffer));
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Test
    public void testTransferTo() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(SOURCE_BYTES)));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        File file = File.createTempFile("undertow-j", ".tmp");
        file.deleteOnExit();
        WebSocket00BinaryFrameSourceChannel channel = new WebSocket00BinaryFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, (WebSocketChannel)mockChannel, (long)TEXT_BYTES.length);
        Assert.assertEquals((String)"Should read 4 bytes", (long)4L, (long)channel.transferTo(0L, 8L, new FileOutputStream(file).getChannel()));
        Assert.assertEquals((String)"Should have transfered 4 bytes", (long)4L, (long)file.length());
        FileInputStream in = new FileInputStream(file);
        int i = 0;
        int b = -1;
        while ((b = ((InputStream)in).read()) != -1) {
            Assert.assertEquals((long)SOURCE_BYTES[i++], (long)b);
        }
        ((InputStream)in).close();
        Assert.assertEquals((long)4L, (long)i);
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel);
    }

    @Ignore(value="Find out why this fails. No idea atm...")
    @Test
    public void testTransferToWithBuffer() throws IOException {
        WebSocket00Channel mockChannel = (WebSocket00Channel)EasyMock.createMock(WebSocket00Channel.class);
        EasyMock.replay((Object[])new Object[]{mockChannel});
        StreamSinkChannel mockSink = (StreamSinkChannel)EasyMock.createMock(StreamSinkChannel.class);
        EasyMock.expect((Object)mockSink.write((ByteBuffer)EasyMock.anyObject(ByteBuffer.class))).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                ByteBuffer buf = (ByteBuffer)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((long)8L, (long)buf.capacity());
                Assert.assertEquals((long)1L, (long)buf.remaining());
                Assert.assertEquals((long)SOURCE_BYTES[0], (long)buf.get());
                return 1;
            }
        });
        EasyMock.replay((Object[])new Object[]{mockSink});
        StreamSourceChannelAdapter sch = new StreamSourceChannelAdapter(Channels.newChannel(new ByteArrayInputStream(SOURCE_BYTES)));
        PushBackStreamChannel pch = new PushBackStreamChannel((StreamSourceChannel)sch);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        WebSocket00BinaryFrameSourceChannel channel = new WebSocket00BinaryFrameSourceChannel((WebSocketChannel.StreamSourceChannelControl)EasyMock.createMock(WebSocketChannel.StreamSourceChannelControl.class), (StreamSourceChannel)pch, (WebSocketChannel)mockChannel, (long)TEXT_BYTES.length);
        Assert.assertEquals((long)1L, (long)channel.transferTo(1L, buffer, mockSink));
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertTrue((boolean)channel.isFinalFragment());
        TestUtils.verifyAndReset(mockChannel, mockSink);
    }

    static {
        System.arraycopy(TEXT_BYTES, 0, SOURCE_BYTES, 0, TEXT_BYTES.length);
        WebSocket00BinaryFrameSourceChannelTest.SOURCE_BYTES[4] = 1;
        WebSocket00BinaryFrameSourceChannelTest.SOURCE_BYTES[5] = 2;
    }
}

