/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.CanonicalPathUtils;
import junit.framework.Assert;
import org.junit.Test;

public class CanonicalPathUtilsTestCase {
    @Test
    public void testCanonicalization() {
        Assert.assertSame((Object)"a/b/c", (Object)CanonicalPathUtils.canonicalize((String)"a/b/c"));
        Assert.assertSame((Object)"aaaaa", (Object)CanonicalPathUtils.canonicalize((String)"aaaaa"));
        Assert.assertEquals((String)"a./b", (String)CanonicalPathUtils.canonicalize((String)"a./b"));
        Assert.assertEquals((String)"a./.b", (String)CanonicalPathUtils.canonicalize((String)"a./.b"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a//b"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a///b"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a////b"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a/./b"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a/././b"));
        Assert.assertEquals((String)"a/b/c", (String)CanonicalPathUtils.canonicalize((String)"a/./b/./c"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a/./././b"));
        Assert.assertEquals((String)"a/b/", (String)CanonicalPathUtils.canonicalize((String)"a/./././b/./"));
        Assert.assertEquals((String)"a/b", (String)CanonicalPathUtils.canonicalize((String)"a/./././b/."));
        Assert.assertEquals((String)"/b", (String)CanonicalPathUtils.canonicalize((String)"/a/../b"));
        Assert.assertEquals((String)"/b", (String)CanonicalPathUtils.canonicalize((String)"/a/../c/../e/../b"));
        Assert.assertEquals((String)"/b", (String)CanonicalPathUtils.canonicalize((String)"/a/c/../../b"));
        Assert.assertEquals((String)"/", (String)CanonicalPathUtils.canonicalize((String)"/a/../.."));
        Assert.assertEquals((String)"/a/", (String)CanonicalPathUtils.canonicalize((String)"/a/"));
        Assert.assertEquals((String)"/", (String)CanonicalPathUtils.canonicalize((String)"/"));
        Assert.assertEquals((String)"/bbb/a", (String)CanonicalPathUtils.canonicalize((String)"/cc/../bbb/a/."));
    }
}

