/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public abstract class WebSocket07FrameSinkChannel
extends StreamSinkFrameChannel {
    private Pooled<ByteBuffer> start;

    protected WebSocket07FrameSinkChannel(StreamSinkChannel channel, WebSocket07Channel wsChannel, WebSocketFrameType type, long payloadSize) {
        super(channel, wsChannel, type, payloadSize);
    }

    private byte opCode() {
        switch (this.getType()) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(this.getType());
    }

    @Override
    protected ByteBuffer createFrameStart() {
        byte b0 = 0;
        if (this.isFinalFragment()) {
            b0 = (byte)(b0 | 0x80);
        }
        b0 = (byte)(b0 | (this.getRsv() & 7) << 4);
        b0 = (byte)(b0 | this.opCode() & 0xF);
        this.start = this.wsChannel.getBufferPool().allocate();
        ByteBuffer header = (ByteBuffer)this.start.getResource();
        if (this.payloadSize <= 125L) {
            header.put(b0);
            header.put((byte)this.payloadSize);
        } else if (this.payloadSize <= 65535L) {
            header.put(b0);
            header.put((byte)126);
            header.put((byte)(this.payloadSize >>> 8 & 0xFFL));
            header.put((byte)(this.payloadSize & 0xFFL));
        } else {
            header.put(b0);
            header.put((byte)127);
            header.putLong(this.payloadSize);
        }
        return header;
    }

    @Override
    protected void frameStartComplete() {
        super.frameStartComplete();
        if (this.start != null) {
            this.start.free();
        }
    }

    @Override
    protected ByteBuffer createFrameEnd() {
        return Buffers.EMPTY_BYTE_BUFFER;
    }
}

