/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public final class HeadStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ConduitListener<? super HeadStreamSinkConduit> finishListener;
    private int state;
    private static final int FLAG_CLOSE_REQUESTED = 1;
    private static final int FLAG_CLOSE_COMPLETE = 2;
    private static final int FLAG_FINISHED_CALLED = 4;

    public HeadStreamSinkConduit(StreamSinkConduit next, ConduitListener<? super HeadStreamSinkConduit> finishListener) {
        super(next);
        this.finishListener = finishListener;
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw new ClosedChannelException();
        }
        int remaining = src.remaining();
        src.position(src.position() + remaining);
        return remaining;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw new ClosedChannelException();
        }
        long total = 0L;
        for (int i = offset; i < offset + length; ++i) {
            ByteBuffer src = srcs[i];
            int remaining = src.remaining();
            total += (long)remaining;
            src.position(src.position() + remaining);
        }
        return total;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int val = this.state;
        if (Bits.anyAreSet((int)val, (int)2)) {
            return true;
        }
        boolean flushed = false;
        try {
            boolean bl = flushed = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.exitFlush(val, flushed);
        }
    }

    public void suspendWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).suspendWrites();
    }

    public void resumeWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).resumeWrites();
    }

    public boolean isWriteResumed() {
        return Bits.allAreClear((int)this.state, (int)2) && ((StreamSinkConduit)this.next).isWriteResumed();
    }

    public void wakeupWrites() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)2L)) {
            return;
        }
        ((StreamSinkConduit)this.next).wakeupWrites();
    }

    public void terminateWrites() throws IOException {
        int newVal;
        int oldVal = this.state;
        if (Bits.anyAreSet((int)oldVal, (int)3)) {
            return;
        }
        this.state = newVal = oldVal | 1;
    }

    private void exitFlush(int oldVal, boolean flushed) {
        int newVal = oldVal;
        boolean callFinish = false;
        if (Bits.anyAreSet((int)oldVal, (int)1) && flushed) {
            newVal |= 2;
            if (!Bits.anyAreSet((int)oldVal, (int)4)) {
                newVal |= 4;
                callFinish = true;
            }
            this.state = newVal;
            if (callFinish && this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
        }
    }
}

