/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.PathParameterSessionConfig;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCookieStore;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class URLRewritingSessionTestCase {
    public static final String COUNT = "count";

    @BeforeClass
    public static void setup() {
        final PathParameterSessionConfig sessionConfig = new PathParameterSessionConfig();
        SessionAttachmentHandler handler = new SessionAttachmentHandler((SessionManager)new InMemorySessionManager(), (SessionConfig)sessionConfig);
        handler.setNext(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                SessionManager manager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                Session session = manager.getSession(exchange, (SessionConfig)sessionConfig);
                if (session == null) {
                    session = manager.createSession(exchange, (SessionConfig)sessionConfig);
                    session.setAttribute(URLRewritingSessionTestCase.COUNT, (Object)0);
                }
                Integer count = (Integer)session.getAttribute(URLRewritingSessionTestCase.COUNT);
                exchange.getResponseHeaders().add(new HttpString(URLRewritingSessionTestCase.COUNT), count.toString());
                count = count + 1;
                session.setAttribute(URLRewritingSessionTestCase.COUNT, (Object)count);
                for (Map.Entry qp : exchange.getQueryParameters().entrySet()) {
                    exchange.getResponseHeaders().add(new HttpString((String)qp.getKey()), (String)((Deque)qp.getValue()).getFirst());
                }
                if (exchange.getQueryString().isEmpty()) {
                    exchange.getResponseSender().send(sessionConfig.rewriteUrl(DefaultServer.getDefaultServerURL() + "/notamatchingpath", session.getId()));
                } else {
                    exchange.getResponseSender().send(sessionConfig.rewriteUrl(DefaultServer.getDefaultServerURL() + "/notamatchingpath?" + exchange.getQueryString(), session.getId()));
                }
            }
        });
        DefaultServer.setRootHandler((HttpHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewriting() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse(result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLRewritingWithQueryParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setCookieStore((CookieStore)new BasicCookieStore());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/notamatchingpath?a=b");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String url = HttpClientUtils.readResponse(result);
            Header[] header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"0", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b", (Object)result.getHeaders("a")[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"1", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b", (Object)result.getHeaders("a")[0].getValue());
            get = new HttpGet(url);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            url = HttpClientUtils.readResponse(result);
            header = result.getHeaders(COUNT);
            Assert.assertEquals((Object)"2", (Object)header[0].getValue());
            Assert.assertEquals((Object)"b", (Object)result.getHeaders("a")[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

