/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.ConstantAccessLogToken;
import io.undertow.server.handlers.accesslog.TokenHandler;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AccessLogHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final TokenHandler[] tokens;
    private final ExchangeCompletionListener exchangeCompletionListener = new AccessLogCompletionListener();

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, TokenHandler.Factory ... factories) {
        this.next = next;
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = formatString;
        ArrayList<ConstantAccessLogToken> tokenHandlers = new ArrayList<ConstantAccessLogToken>();
        StringTokenizer tokeniser = new StringTokenizer(formatString, " ", false);
        while (tokeniser.hasMoreElements()) {
            TokenHandler.Factory factory;
            String elem = (String)tokeniser.nextElement();
            TokenHandler tokenHandler = null;
            TokenHandler.Factory[] arr$ = factories;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (tokenHandler = (factory = arr$[i$]).create(elem)) == null; ++i$) {
            }
            if (tokenHandler == null) {
                tokenHandler = new ConstantAccessLogToken(elem);
            }
            tokenHandlers.add((ConstantAccessLogToken)tokenHandler);
        }
        this.tokens = tokenHandlers.toArray(new TokenHandler[tokenHandlers.size()]);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + '\'' + '}';
    }

    private class AccessLogCompletionListener
    implements ExchangeCompletionListener {
        private AccessLogCompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < AccessLogHandler.this.tokens.length; ++i) {
                    String result = AccessLogHandler.this.tokens[i].generateMessage(exchange);
                    if (result == null) {
                        builder.append('-');
                    } else {
                        builder.append(result);
                    }
                    if (i == AccessLogHandler.this.tokens.length - 1) continue;
                    builder.append(' ');
                }
                AccessLogHandler.this.accessLogReceiver.logMessage(builder.toString());
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

