/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.List;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;

public final class ChannelUpgradeHandler
implements HttpHandler {
    private final CopyOnWriteMap<String, ChannelListener<? super ConnectedStreamChannel>> handlers = new CopyOnWriteMap();
    private volatile HttpHandler nonUpgradeHandler = ResponseCodeHandler.HANDLE_404;

    public boolean addProtocol(String productString, ChannelListener<? super ConnectedStreamChannel> openListener) {
        if (productString == null) {
            throw new IllegalArgumentException("productString is null");
        }
        if (openListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        return this.handlers.putIfAbsent(productString, openListener) == null;
    }

    public ChannelListener<? super ConnectedStreamChannel> removeProtocol(String productString) {
        return this.handlers.remove(productString);
    }

    public HttpHandler getNonUpgradeHandler() {
        return this.nonUpgradeHandler;
    }

    public ChannelUpgradeHandler setNonUpgradeHandler(HttpHandler nonUpgradeHandler) {
        HttpHandlers.handlerNotNull(nonUpgradeHandler);
        this.nonUpgradeHandler = nonUpgradeHandler;
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List<String> upgradeStrings = exchange.getRequestHeaders().get(Headers.UPGRADE);
        if (upgradeStrings != null && exchange.getRequestMethod().equals(Methods.GET)) {
            for (String string : upgradeStrings) {
                final ChannelListener<? super ConnectedStreamChannel> listener = this.handlers.get(string);
                if (listener == null) continue;
                exchange.upgradeChannel(string, new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(final HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        try {
                            exchange.getRequestChannel().shutdownReads();
                            StreamSinkChannel sinkChannel = exchange.getResponseChannel();
                            sinkChannel.shutdownWrites();
                            if (!sinkChannel.flush()) {
                                sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<Channel>(){

                                    public void handleEvent(Channel channel) {
                                        ChannelListeners.invokeChannelListener((Channel)exchange.getConnection().getChannel(), (ChannelListener)listener);
                                    }
                                }, null));
                                sinkChannel.resumeWrites();
                            } else {
                                ChannelListeners.invokeChannelListener((Channel)exchange.getConnection().getChannel(), (ChannelListener)listener);
                            }
                            return;
                        }
                        catch (IOException e) {
                            exchange.endExchange();
                            UndertowLogger.REQUEST_LOGGER.debug("Exception handling request", e);
                            return;
                        }
                    }
                });
                exchange.endExchange();
            }
        }
        HttpHandler handler = this.nonUpgradeHandler;
        HttpHandlers.executeHandler(handler, exchange);
    }
}

