/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.util.SecureHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;

public class InMemorySessionManager
implements SessionManager {
    private volatile SessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
    private final ConcurrentMap<String, InMemorySession> sessions = new SecureHashMap<String, InMemorySession>();
    private volatile List<SessionListener> listeners = Collections.emptyList();
    private volatile int defaultSessionTimeout = 1800;

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.sessions.clear();
    }

    @Override
    public Session createSession(HttpServerExchange serverExchange, SessionConfig config) {
        Object session;
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String sessionID = config.findSessionId(serverExchange);
        if (sessionID != null) {
            session = (InMemorySession)this.sessions.get(sessionID);
            if (session != null) {
                throw UndertowMessages.MESSAGES.sessionAlreadyExists(sessionID);
            }
        } else {
            sessionID = this.sessionIdGenerator.createSessionId();
        }
        session = new SessionImpl(sessionID, config, serverExchange.getIoThread(), serverExchange.getConnection().getWorker());
        InMemorySession im = new InMemorySession((Session)session, this.defaultSessionTimeout);
        this.sessions.put(sessionID, im);
        for (SessionListener listener : this.listeners) {
            listener.sessionCreated((Session)session, serverExchange);
        }
        config.setSessionId(serverExchange, ((SessionImpl)session).getId());
        im.lastAccessed = System.currentTimeMillis();
        ((SessionImpl)session).bumpTimeout();
        return session;
    }

    @Override
    public Session getSession(HttpServerExchange serverExchange, SessionConfig config) {
        String sessionId = config.findSessionId(serverExchange);
        if (sessionId == null) {
            return null;
        }
        InMemorySession sess = (InMemorySession)this.sessions.get(sessionId);
        if (sess == null) {
            return null;
        }
        config.setSessionId(serverExchange, sess.session.getId());
        return sess.session;
    }

    @Override
    public synchronized void registerSessionListener(SessionListener listener) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.listeners);
        listeners.add(listener);
        this.listeners = Collections.unmodifiableList(listeners);
    }

    @Override
    public synchronized void removeSessionListener(SessionListener listener) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.listeners);
        listeners.remove(listener);
        this.listeners = Collections.unmodifiableList(listeners);
    }

    @Override
    public void setDefaultSessionTimeout(int timeout) {
        this.defaultSessionTimeout = timeout;
    }

    private static class InMemorySession {
        final Session session;
        final ConcurrentMap<String, Object> attributes = new SecureHashMap<String, Object>();
        volatile long lastAccessed;
        final long creationTime;
        volatile int maxInactiveInterval;

        InMemorySession(Session session, int maxInactiveInterval) {
            this.session = session;
            this.creationTime = this.lastAccessed = System.currentTimeMillis();
            this.maxInactiveInterval = maxInactiveInterval;
        }
    }

    private class SessionImpl
    implements Session {
        private String sessionId;
        private final SessionConfig sessionCookieConfig;
        final XnioExecutor executor;
        final XnioWorker worker;
        XnioExecutor.Key cancelKey;
        final Runnable cancelTask = new Runnable(){

            @Override
            public void run() {
                SessionImpl.this.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        SessionImpl.this.invalidate(null);
                    }
                });
            }
        };

        private SessionImpl(String sessionId, SessionConfig sessionCookieConfig, XnioExecutor executor, XnioWorker worker) {
            this.sessionId = sessionId;
            this.sessionCookieConfig = sessionCookieConfig;
            this.executor = executor;
            this.worker = worker;
        }

        synchronized void bumpTimeout() {
            if (this.cancelKey != null && !this.cancelKey.remove()) {
                return;
            }
            this.cancelKey = this.executor.executeAfter(this.cancelTask, (long)this.getMaxInactiveInterval(), TimeUnit.SECONDS);
        }

        @Override
        public String getId() {
            return this.sessionId;
        }

        @Override
        public void requestDone(HttpServerExchange serverExchange) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess != null) {
                sess.lastAccessed = System.currentTimeMillis();
            }
        }

        @Override
        public long getCreationTime() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.lastAccessed;
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            sess.maxInactiveInterval = interval;
            this.bumpTimeout();
        }

        @Override
        public int getMaxInactiveInterval() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.maxInactiveInterval;
        }

        @Override
        public Object getAttribute(String name) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            this.bumpTimeout();
            return sess.attributes.get(name);
        }

        @Override
        public Set<String> getAttributeNames() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            this.bumpTimeout();
            return sess.attributes.keySet();
        }

        @Override
        public Object setAttribute(String name, Object value) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.put(name, value);
            for (SessionListener listener : InMemorySessionManager.this.listeners) {
                if (existing == null) {
                    listener.attributeAdded(sess.session, name, value);
                    continue;
                }
                listener.attributeUpdated(sess.session, name, value);
            }
            this.bumpTimeout();
            return existing;
        }

        @Override
        public Object removeAttribute(String name) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.remove(name);
            for (SessionListener listener : InMemorySessionManager.this.listeners) {
                listener.attributeRemoved(sess.session, name);
            }
            this.bumpTimeout();
            return existing;
        }

        @Override
        public void invalidate(HttpServerExchange exchange) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.remove(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionAlreadyInvalidated();
            }
            for (SessionListener listener : InMemorySessionManager.this.listeners) {
                listener.sessionDestroyed(sess.session, exchange, false);
            }
            if (exchange != null) {
                this.sessionCookieConfig.clearSession(exchange, this.getId());
            }
        }

        @Override
        public SessionManager getSessionManager() {
            return InMemorySessionManager.this;
        }

        @Override
        public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
            String newId;
            String oldId = this.sessionId;
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(oldId);
            this.sessionId = newId = InMemorySessionManager.this.sessionIdGenerator.createSessionId();
            InMemorySessionManager.this.sessions.put(newId, sess);
            InMemorySessionManager.this.sessions.remove(oldId);
            config.setSessionId(exchange, this.getId());
            return newId;
        }
    }
}

