/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileHandlerStressTestCase {
    public static final int NUM_THREADS = 10;
    public static final int NUM_REQUESTS = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleFileStressTest() throws IOException, ExecutionException, InterruptedException, URISyntaxException {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
            ResourceHandler handler = new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(rootPath));
            CacheHandler cacheHandler = new CacheHandler(new DirectBufferCache(1024, 10480), (HttpHandler)handler);
            PathHandler path = new PathHandler();
            path.addPath("/path", (HttpHandler)cacheHandler);
            CanonicalPathHandler root = new CanonicalPathHandler();
            root.setNext((HttpHandler)path);
            DefaultServer.setRootHandler((HttpHandler)root);
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            for (int i = 0; i < 100; ++i) {
                                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
                                HttpResponse result = client.execute((HttpUriRequest)get);
                                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                                String response = HttpClientUtils.readResponse(result);
                                Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
    }
}

