/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.utils;

import io.undertow.UndertowOptions;
import io.undertow.ajp.AjpOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpOpenListener;
import io.undertow.server.OpenListener;
import io.undertow.test.utils.AjpIgnore;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.ssl.JsseXnioSsl;

public class DefaultServer
extends BlockJUnit4ClassRunner {
    private static final String DEFAULT = "default";
    private static boolean first = true;
    private static OptionMap serverOptions;
    private static OpenListener openListener;
    private static ChannelListener acceptListener;
    private static XnioWorker worker;
    private static AcceptingChannel<? extends ConnectedStreamChannel> server;
    private static AcceptingChannel<? extends ConnectedStreamChannel> sslServer;
    private static SSLContext clientSslContext;
    private static Xnio xnio;
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    private static final String CLIENT_KEY_STORE = "client.keystore";
    private static final String CLIENT_TRUST_STORE = "client.truststore";
    private static final char[] STORE_PASSWORD;
    private static final boolean ajp;

    private static KeyStore loadKeyStore(String name) throws IOException {
        InputStream stream = DefaultServer.class.getClassLoader().getResourceAsStream(name);
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws IOException {
        SSLContext sslContext;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        return sslContext;
    }

    public static String getDefaultServerURL() {
        return "http://" + DefaultServer.getHostAddress(DEFAULT) + ":" + DefaultServer.getHostPort(DEFAULT);
    }

    public static InetSocketAddress getDefaultServerAddress() {
        return new InetSocketAddress(DefaultServer.getHostAddress(DEFAULT), DefaultServer.getHostPort(DEFAULT));
    }

    public static String getDefaultServerSSLAddress() {
        if (sslServer == null) {
            throw new IllegalStateException("SSL Server not started.");
        }
        return "https://" + DefaultServer.getHostAddress(DEFAULT) + ":" + DefaultServer.getHostSSLPort(DEFAULT);
    }

    public DefaultServer(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        DefaultServer.runInternal(notifier);
        super.run(notifier);
    }

    private static void runInternal(RunNotifier notifier) {
        if (first) {
            first = false;
            xnio = Xnio.getInstance((String)"nio", (ClassLoader)DefaultServer.class.getClassLoader());
            try {
                worker = xnio.createWorker(OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 30).set(Options.WORKER_TASK_MAX_THREADS, 30).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
                serverOptions = OptionMap.builder().set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
                if (ajp) {
                    openListener = new AjpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), 8192);
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
                    server = worker.createStreamServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), 7777), acceptListener, serverOptions);
                } else {
                    openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 819200), OptionMap.create((Option)UndertowOptions.BUFFER_PIPELINED_DATA, (Object)true), 8192);
                    acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)openListener);
                    server = worker.createStreamServer((SocketAddress)new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostPort(DEFAULT)), acceptListener, serverOptions);
                }
                server.resumeAccepts();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            notifier.addListener(new RunListener(){

                public void testRunFinished(Result result) throws Exception {
                    server.close();
                    DefaultServer.stopSSLServer();
                    worker.shutdown();
                }
            });
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (ajp && (method.getAnnotation(AjpIgnore.class) != null || method.getMethod().getDeclaringClass().isAnnotationPresent(AjpIgnore.class))) {
            return;
        }
        super.runChild(method, notifier);
    }

    public static void setRootHandler(HttpHandler rootHandler) {
        if (ajp) {
            openListener.setRootHandler(rootHandler);
        } else {
            openListener.setRootHandler(rootHandler);
        }
    }

    public static SSLContext getClientSSLContext() {
        return clientSslContext;
    }

    public static void startSSLServer() throws IOException {
        SSLContext serverContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(SERVER_KEY_STORE), DefaultServer.loadKeyStore(SERVER_TRUST_STORE));
        clientSslContext = DefaultServer.createSSLContext(DefaultServer.loadKeyStore(CLIENT_KEY_STORE), DefaultServer.loadKeyStore(CLIENT_TRUST_STORE));
        DefaultServer.startSSLServer(serverContext, OptionMap.create((Option)Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED));
    }

    public static void startSSLServer(SSLContext context, OptionMap options) throws IOException {
        OptionMap combined = OptionMap.builder().addAll(serverOptions).addAll(options).getMap();
        JsseXnioSsl xnioSsl = new JsseXnioSsl(xnio, combined, context);
        sslServer = xnioSsl.createSslTcpServer(worker, new InetSocketAddress(Inet4Address.getByName(DefaultServer.getHostAddress(DEFAULT)), DefaultServer.getHostSSLPort(DEFAULT)), acceptListener, combined);
        sslServer.resumeAccepts();
    }

    public static void stopSSLServer() throws IOException {
        if (sslServer != null) {
            sslServer.close();
            sslServer = null;
        }
        clientSslContext = null;
    }

    public static String getHostAddress(String serverName) {
        return System.getProperty(serverName + ".server.address", "localhost");
    }

    public static int getHostPort(String serverName) {
        return Integer.getInteger(serverName + ".server.port", 7777) + (ajp ? 1111 : 0);
    }

    public static int getHostSSLPort(String serverName) {
        return Integer.getInteger(serverName + ".server.sslPort", 7778);
    }

    public static OptionMap getUndertowOptions() {
        return openListener.getUndertowOptions();
    }

    public static void setUndertowOptions(OptionMap options) {
        openListener.setUndertowOptions(options);
    }

    public static boolean isAjp() {
        return ajp;
    }

    static {
        STORE_PASSWORD = "password".toCharArray();
        ajp = Boolean.getBoolean("ajp");
    }

    public static class Parameterized
    extends org.junit.runners.Parameterized {
        public Parameterized(Class<?> klass) throws Throwable {
            super(klass);
        }

        public void run(RunNotifier notifier) {
            DefaultServer.runInternal(notifier);
            super.run(notifier);
        }
    }
}

