/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.server.HttpHandler;
import io.undertow.test.utils.DefaultServer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.protocol.version00.WebSocket00ServerTest;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.ChannelListener;

public class WebSocket07ServerTest
extends WebSocket00ServerTest {
    @Override
    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V07;
    }

    @Test
    public void testPing() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = channel.receive();
                            if (ws == null) {
                                return;
                            }
                            Assert.assertEquals((Object)WebSocketFrameType.PING, (Object)ws.getType());
                            ByteBuffer buf = ByteBuffer.allocate(32);
                            while (ws.read(buf) != -1) {
                            }
                            buf.flip();
                            StreamSinkFrameChannel sink = channel.send(WebSocketFrameType.PONG, (long)buf.remaining());
                            Assert.assertEquals((Object)WebSocketFrameType.PONG, (Object)sink.getType());
                            while (buf.hasRemaining()) {
                                sink.write(buf);
                            }
                            Assert.assertTrue((boolean)sink.flush());
                            channel.getReceiveSetter().set(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        CountDownLatch latch = new CountDownLatch(1);
        byte[] payload = "payload".getBytes();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + DefaultServer.getHostAddress("default") + ':' + DefaultServer.getHostPort("default") + '/'));
        client.connect();
        client.send((WebSocketFrame)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)), new FrameChecker(PongWebSocketFrame.class, payload, latch));
        latch.await();
        client.destroy();
    }
}

