/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpOpenListener;
import io.undertow.websockets.api.AbstractFragmentedFrameHandler;
import io.undertow.websockets.api.FragmentedBinaryFrameSender;
import io.undertow.websockets.api.FragmentedTextFrameSender;
import io.undertow.websockets.api.FrameHandler;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.api.WebSocketSessionIdGenerator;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.impl.UuidWebSocketSessionIdGenerator;
import io.undertow.websockets.impl.WebSocketSessionConnectionCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.ConnectedStreamChannel;

public class HighLevelAutobahnWebSocketServer {
    private HttpOpenListener openListener;
    private XnioWorker worker;
    private AcceptingChannel<? extends ConnectedStreamChannel> server;
    private Xnio xnio;
    private final int port;
    private static final SendCallback PRINT_ERROR_SEND_CALLBACK = new SendCallback(){

        public void onCompletion() {
        }

        public void onError(Throwable cause) {
            cause.printStackTrace();
        }
    };

    public HighLevelAutobahnWebSocketServer(int port) {
        this.port = port;
    }

    public void run() {
        this.xnio = Xnio.getInstance((String)"nio");
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_WRITE_THREADS, 4).set(Options.WORKER_READ_THREADS, 4).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 10).set(Options.WORKER_TASK_MAX_THREADS, 12).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.WORKER_ACCEPT_THREADS, 4).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
            this.openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 8192, 0x4000000), 8192);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            this.server = this.worker.createStreamServer((SocketAddress)new InetSocketAddress(this.port), acceptListener, serverOptions);
            this.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler((WebSocketConnectionCallback)new WebSocketSessionConnectionCallback((WebSocketSessionIdGenerator)new UuidWebSocketSessionIdGenerator(), (WebSocketSessionHandler)new WebSocketSessionHandlerImpl(), false)));
            this.server.resumeAccepts();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setRootHandler(HttpHandler rootHandler) {
        this.openListener.setRootHandler(rootHandler);
    }

    public static void main(String[] args) {
        new HighLevelAutobahnWebSocketServer(7777).run();
    }

    private static final class WebSocketSessionHandlerImpl
    implements WebSocketSessionHandler {
        private WebSocketSessionHandlerImpl() {
        }

        public void onSession(WebSocketSession session, WebSocketHttpExchange exchange) {
            session.setFrameHandler((FrameHandler)new AbstractFragmentedFrameHandler(){
                private FragmentedBinaryFrameSender binaryFrameSender;
                private FragmentedTextFrameSender textFrameSender;

                public void onTextFrame(WebSocketSession session, WebSocketFrameHeader header, ByteBuffer ... payload) {
                    FragmentedTextFrameSender textFrameSender = this.textFrameSender;
                    if (textFrameSender == null) {
                        textFrameSender = this.textFrameSender = session.sendFragmentedText();
                    }
                    if (header.isLastFragement()) {
                        textFrameSender.finalFragment();
                        this.textFrameSender = null;
                    }
                    textFrameSender.sendText(this.copy(payload), PRINT_ERROR_SEND_CALLBACK);
                }

                public void onBinaryFrame(WebSocketSession session, WebSocketFrameHeader header, ByteBuffer ... payload) {
                    FragmentedBinaryFrameSender binaryFrameSender = this.binaryFrameSender;
                    if (binaryFrameSender == null) {
                        binaryFrameSender = this.binaryFrameSender = session.sendFragmentedBinary();
                    }
                    if (header.isLastFragement()) {
                        binaryFrameSender.finalFragment();
                        this.binaryFrameSender = null;
                    }
                    binaryFrameSender.sendBinary(this.copy(payload), PRINT_ERROR_SEND_CALLBACK);
                }

                public void onPongFrame(WebSocketSession session, ByteBuffer ... payload) {
                    System.out.println("PONG!!!");
                }

                public void onError(WebSocketSession session, Throwable cause) {
                    cause.printStackTrace();
                }

                private ByteBuffer[] copy(ByteBuffer ... payload) {
                    ByteBuffer[] buffers = new ByteBuffer[payload.length];
                    for (int i = 0; i < payload.length; ++i) {
                        ByteBuffer src = payload[i];
                        ByteBuffer buffer = ByteBuffer.allocate(src.remaining());
                        buffer.put(src);
                        buffer.flip();
                        buffers[i] = buffer;
                    }
                    return buffers;
                }
            });
        }
    }
}

