/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.TruncatedResponseException;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HttpString;
import io.undertow.util.StatusCodes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.xnio.Bits;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

final class HttpResponseConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final Pool<ByteBuffer> pool;
    private int state = 1;
    private Iterator<HttpString> nameIterator;
    private String string;
    private HttpString headerName;
    private Iterator<String> valueIterator;
    private int charIndex;
    private Pooled<ByteBuffer> pooledBuffer;
    private final HttpServerExchange exchange;
    private static final int STATE_BODY = 0;
    private static final int STATE_START = 1;
    private static final int STATE_HDR_NAME = 2;
    private static final int STATE_HDR_D = 3;
    private static final int STATE_HDR_DS = 4;
    private static final int STATE_HDR_VAL = 5;
    private static final int STATE_HDR_EOL_CR = 6;
    private static final int STATE_HDR_EOL_LF = 7;
    private static final int STATE_HDR_FINAL_CR = 8;
    private static final int STATE_HDR_FINAL_LF = 9;
    private static final int STATE_BUF_FLUSH = 10;
    private static final int MASK_STATE = 15;
    private static final int FLAG_SHUTDOWN = 16;
    public static final ConduitWrapper<StreamSinkConduit> WRAPPER = new ConduitWrapper<StreamSinkConduit>(){

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            StreamSinkConduit channel = factory.create();
            return new HttpResponseConduit(channel, exchange.getConnection().getBufferPool(), exchange);
        }
    };

    HttpResponseConduit(StreamSinkConduit next, Pool<ByteBuffer> pool, HttpServerExchange exchange) {
        super(next);
        this.pool = pool;
        this.exchange = exchange;
    }

    /*
     * Unable to fully structure code
     */
    private int processWrite(int state, ByteBuffer userData) throws IOException {
        if (state == 1) {
            this.pooledBuffer = this.pool.allocate();
        }
        buffer = (ByteBuffer)this.pooledBuffer.getResource();
        nameIterator = this.nameIterator;
        valueIterator = this.valueIterator;
        charIndex = this.charIndex;
        string = this.string;
        headerName = this.headerName;
        if (state != 1 && buffer.hasRemaining()) {
            do {
                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                return state;
            } while (buffer.hasRemaining());
        }
        buffer.clear();
        block14: while (true) {
            switch (state) {
                case 0: {
                    return state;
                }
                case 1: {
                    if (!HttpResponseConduit.$assertionsDisabled && buffer.remaining() < 256) {
                        throw new AssertionError();
                    }
                    this.exchange.getProtocol().appendTo(buffer);
                    buffer.put((byte)32);
                    code = this.exchange.getResponseCode();
                    if (!(HttpResponseConduit.$assertionsDisabled || 999 >= code && code >= 100)) {
                        throw new AssertionError();
                    }
                    buffer.put((byte)(code / 100 + 48));
                    buffer.put((byte)(code / 10 % 10 + 48));
                    buffer.put((byte)(code % 10 + 48));
                    buffer.put((byte)32);
                    string = StatusCodes.getReason(code);
                    length = string.length();
                    for (charIndex = 0; charIndex < length; ++charIndex) {
                        buffer.put((byte)string.charAt(charIndex));
                    }
                    buffer.put((byte)13).put((byte)10);
                    headers = this.exchange.getResponseHeaders();
                    nameIterator = headers.iterator();
                    if (!nameIterator.hasNext()) {
                        buffer.put((byte)13).put((byte)10);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            res = ((StreamSinkConduit)this.next).write(buffer);
                            if (res != 0) continue;
                            return 10;
                        }
                        this.pooledBuffer.free();
                        this.pooledBuffer = null;
                        return 0;
                    }
                    headerName = nameIterator.next();
                    charIndex = 0;
                }
                case 2: {
                    length = headerName.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put(headerName.byteAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 2;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                case 3: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 3;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)58);
                }
                case 4: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 4;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)32);
                    if (valueIterator == null) {
                        valueIterator = this.exchange.getResponseHeaders().get(headerName).iterator();
                    }
                    if (!HttpResponseConduit.$assertionsDisabled && !valueIterator.hasNext()) {
                        throw new AssertionError();
                    }
                    string = valueIterator.next();
                    charIndex = 0;
                }
                case 5: {
                    length = string.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)string.charAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 5;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    charIndex = 0;
                    if (!valueIterator.hasNext()) {
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                            return 6;
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                            return 7;
                        }
                        buffer.put((byte)10);
                        if (nameIterator.hasNext()) {
                            headerName = nameIterator.next();
                            valueIterator = null;
                            state = 2;
                            continue block14;
                        }
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                            return 8;
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                            return 9;
                        }
                        buffer.put((byte)10);
                        this.nameIterator = null;
                        this.valueIterator = null;
                        this.string = null;
                        buffer.flip();
                        if (userData == null) {
                            do {
                                if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                                return 10;
                            } while (buffer.hasRemaining());
                        } else {
                            b = new ByteBuffer[]{buffer, userData};
                            do {
                                if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L || !buffer.hasRemaining()) continue;
                                return 10;
                            } while (buffer.hasRemaining());
                        }
                        this.pooledBuffer.free();
                        this.pooledBuffer = null;
                        return 0;
                    }
                }
                case 6: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                        return 6;
                    }
                    buffer.put((byte)13);
                }
                case 7: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                        return 7;
                    }
                    buffer.put((byte)10);
                    if (valueIterator.hasNext()) {
                        state = 2;
                        continue block14;
                    }
                    if (nameIterator.hasNext()) {
                        headerName = nameIterator.next();
                        valueIterator = null;
                        state = 2;
                        continue block14;
                    }
                }
                case 8: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                        return 8;
                    }
                    buffer.put((byte)13);
                }
                case 9: {
                    if (!buffer.hasRemaining() && this.flushHeaderBuffer(buffer)) {
                        return 9;
                    }
                    buffer.put((byte)10);
                    this.nameIterator = null;
                    this.valueIterator = null;
                    this.string = null;
                    buffer.flip();
                    if (userData != null) ** GOTO lbl224
                    do {
                        if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
                        return 10;
                    } while (buffer.hasRemaining());
                    ** GOTO lbl229
lbl224:
                    // 1 sources

                    b = new ByteBuffer[]{buffer, userData};
                    do {
                        if ((r = ((StreamSinkConduit)this.next).write(b, 0, b.length)) != 0L) continue;
                        return 10;
                    } while (buffer.hasRemaining());
                }
lbl229:
                // 3 sources

                case 10: {
                    this.pooledBuffer.free();
                    this.pooledBuffer = null;
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private boolean flushHeaderBuffer(ByteBuffer buffer) throws IOException {
        buffer.flip();
        do {
            int res;
            if ((res = ((StreamSinkConduit)this.next).write(buffer)) != 0) continue;
            return true;
        } while (buffer.hasRemaining());
        buffer.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        int oldState = this.state;
        int state = oldState & 0xF;
        int alreadyWritten = 0;
        int originalRemaining = -1;
        try {
            if (state != 0) {
                originalRemaining = src.remaining();
                if ((state = this.processWrite(state, src)) != 0) {
                    int n = 0;
                    return n;
                }
                alreadyWritten = originalRemaining - src.remaining();
                if (Bits.allAreSet((int)oldState, (int)16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            if (alreadyWritten != originalRemaining) {
                int n = ((StreamSinkConduit)this.next).write(src) + alreadyWritten;
                return n;
            }
            int n = alreadyWritten;
            return n;
        }
        finally {
            this.state = oldState & 0xFFFFFFF0 | state;
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet((int)oldVal, (int)16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = length == 1 ? (long)((StreamSinkConduit)this.next).write(srcs[offset]) : ((StreamSinkConduit)this.next).write(srcs, offset, length);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet((int)oldVal, (int)16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(src, position, count);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (count == 0L) {
            throughBuffer.clear().limit(0);
            return 0L;
        }
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    long l = 0L;
                    return l;
                }
                if (Bits.allAreSet((int)oldVal, (int)16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
            return l;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int oldVal = this.state;
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state, null)) != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (Bits.allAreSet((int)oldVal, (int)16)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
            }
            boolean bl = ((StreamSinkConduit)this.next).flush();
            return bl;
        }
        finally {
            this.state = oldVal & 0xFFFFFFF0 | state;
        }
    }

    public void terminateWrites() throws IOException {
        int oldVal = this.state;
        if (Bits.allAreClear((int)oldVal, (int)15)) {
            ((StreamSinkConduit)this.next).terminateWrites();
            return;
        }
        this.state = oldVal | 0x10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateWrites() throws IOException {
        int oldVal = this.state;
        if (Bits.allAreClear((int)oldVal, (int)15)) {
            try {
                ((StreamSinkConduit)this.next).truncateWrites();
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.free();
                    this.pooledBuffer = null;
                }
            }
            return;
        }
        this.state = oldVal & 0xFFFFFFF0 | 0x10 | 0;
        throw new TruncatedResponseException();
    }

    public XnioWorker getWorker() {
        return ((StreamSinkConduit)this.next).getWorker();
    }
}

