/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers.blocking;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.Methods;
import io.undertow.util.TestHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleBlockingServerTestCase {
    private static volatile String message;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (exchange.getRequestMethod().equals(Methods.POST)) {
                        byte[] buffer = new byte[1024];
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        int r = 0;
                        OutputStream outputStream = exchange.getOutputStream();
                        InputStream inputStream = exchange.getInputStream();
                        while ((r = inputStream.read(buffer)) > 0) {
                            b.write(buffer, 0, r);
                        }
                        outputStream.write(b.toByteArray());
                        outputStream.close();
                    } else {
                        OutputStream outputStream = exchange.getOutputStream();
                        outputStream.write(message.getBytes());
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpRequest() throws IOException {
        message = "My HTTP Request!";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeResponse() throws IOException {
        StringBuilder messageBuilder = new StringBuilder(6919638);
        for (int i = 0; i < 6919638; ++i) {
            messageBuilder.append("*");
        }
        message = messageBuilder.toString();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)message.equals(HttpClientUtils.readResponse(result)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeRequest() throws IOException {
        message = null;
        StringBuilder messageBuilder = new StringBuilder(6919638);
        for (int i = 0; i < 6919638; ++i) {
            messageBuilder.append("+");
        }
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setEntity((HttpEntity)new StringEntity(messageBuilder.toString()));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)messageBuilder.toString().equals(HttpClientUtils.readResponse(result)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

