/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class StreamSinkChannelFacade
implements StreamSinkChannel {
    private static final int WRITES_SHUTDOWN = 1;
    private static final int CLOSED = 2;
    protected final StreamSinkChannel delegate;
    protected final ChannelListener.SimpleSetter<StreamSinkChannelFacade> writeSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<StreamSinkChannelFacade> closeSetter = new ChannelListener.SimpleSetter();
    private int state = 0;

    public StreamSinkChannelFacade(StreamSinkChannel delegate) {
        this.delegate = delegate;
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
    }

    public void suspendWrites() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.delegate.suspendWrites();
    }

    public void resumeWrites() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.delegate.resumeWrites();
    }

    public boolean isWriteResumed() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return false;
        }
        return this.delegate.isWriteResumed();
    }

    public void wakeupWrites() {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.delegate.wakeupWrites();
    }

    public void shutdownWrites() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.state |= 1;
        this.delegate.shutdownWrites();
    }

    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.delegate.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public boolean isOpen() {
        return !Bits.anyAreSet((int)this.state, (int)2);
    }

    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.state |= 2;
        this.delegate.close();
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        boolean res = this.delegate.flush();
        if (res && Bits.anyAreSet((int)this.state, (int)1)) {
            this.state |= 2;
        }
        return res;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.transferFrom(src, position, count);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(srcs, offset, length);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(srcs);
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return (T)this.delegate.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return (T)this.delegate.setOption(option, value);
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(src);
    }
}

