/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class StreamSourceChannelFacade
implements StreamSourceChannel {
    protected final ChannelListener.SimpleSetter<StreamSourceChannelFacade> readSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<StreamSourceChannelFacade> closeSetter = new ChannelListener.SimpleSetter();
    protected final StreamSourceChannel delegate;
    private boolean closed = false;

    public StreamSourceChannelFacade(StreamSourceChannel delegate) {
        this.delegate = delegate;
        delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.readSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        long res = this.delegate.transferTo(position, count, target);
        if (res == -1L) {
            this.closed = true;
        }
        return res;
    }

    public void awaitReadable() throws IOException {
        this.delegate.awaitReadable();
    }

    public void suspendReads() {
        this.delegate.suspendReads();
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        long res = this.delegate.transferTo(count, throughBuffer, target);
        if (res == -1L) {
            this.closed = true;
        }
        return res;
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public boolean isReadResumed() {
        if (this.closed) {
            return false;
        }
        return this.delegate.isReadResumed();
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return (T)this.delegate.setOption(option, value);
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public void shutdownReads() throws IOException {
        if (this.closed) {
            return;
        }
        this.delegate.shutdownReads();
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public boolean isOpen() {
        if (this.closed) {
            return false;
        }
        return this.delegate.isOpen();
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        long res = this.delegate.read(dsts);
        if (res == -1L) {
            this.closed = true;
        }
        return res;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        long res = this.delegate.read(dsts, offset, length);
        if (res == -1L) {
            this.closed = true;
        }
        return res;
    }

    public void wakeupReads() {
        if (this.closed) {
            return;
        }
        this.delegate.wakeupReads();
    }

    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.delegate.close();
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return (T)this.delegate.getOption(option);
    }

    public void resumeReads() {
        if (this.closed) {
            return;
        }
        this.delegate.resumeReads();
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        int res = this.delegate.read(dst);
        if (res == -1) {
            this.closed = true;
        }
        return res;
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }
}

