/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

class WebSocket00BinaryFrameSinkChannel
extends StreamSinkFrameChannel {
    private Pooled<ByteBuffer> start;

    WebSocket00BinaryFrameSinkChannel(StreamSinkChannel channel, WebSocket00Channel wsChannel, long payloadSize) {
        super(channel, wsChannel, WebSocketFrameType.BINARY, payloadSize);
    }

    @Override
    protected ByteBuffer createFrameStart() {
        int dataLen = (int)this.payloadSize;
        this.start = this.wsChannel.getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)this.start.getResource();
        buffer.put((byte)-128);
        int b1 = dataLen >>> 28 & 0x7F;
        int b2 = dataLen >>> 14 & 0x7F;
        int b3 = dataLen >>> 7 & 0x7F;
        int b4 = dataLen & 0x7F;
        if (b1 == 0) {
            if (b2 == 0) {
                if (b3 == 0) {
                    buffer.put((byte)b4);
                } else {
                    buffer.put((byte)(b3 | 0x80));
                    buffer.put((byte)b4);
                }
            } else {
                buffer.put((byte)(b2 | 0x80));
                buffer.put((byte)(b3 | 0x80));
                buffer.put((byte)b4);
            }
        } else {
            buffer.put((byte)(b1 | 0x80));
            buffer.put((byte)(b2 | 0x80));
            buffer.put((byte)(b3 | 0x80));
            buffer.put((byte)b4);
        }
        return buffer;
    }

    @Override
    protected void frameStartComplete() {
        super.frameStartComplete();
        if (this.start != null) {
            this.start.free();
        }
    }

    @Override
    protected ByteBuffer createFrameEnd() {
        return Buffers.EMPTY_BYTE_BUFFER;
    }
}

