/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import io.undertow.testutils.DefaultServer;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class TestHttpClient
extends DefaultHttpClient {
    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler(0, false);
    }

    protected HttpParams createHttpParams() {
        HttpParams params = super.createHttpParams();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
        return params;
    }

    public void setSSLContext(SSLContext sslContext) {
        SchemeRegistry registry = this.getConnectionManager().getSchemeRegistry();
        registry.unregister("https");
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(sslContext)));
        registry.register(new Scheme("https", DefaultServer.getHostSSLPort("default"), (SchemeSocketFactory)new SSLSocketFactory(sslContext)));
    }
}

