/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CompletionLatchHandler
implements HttpHandler {
    private final HttpHandler next;
    private volatile CountDownLatch latch;

    public CompletionLatchHandler(HttpHandler next) {
        this.next = next;
        this.latch = new CountDownLatch(1);
    }

    public CompletionLatchHandler(int size, HttpHandler next) {
        this.next = next;
        this.latch = new CountDownLatch(size);
    }

    public void await() {
        try {
            this.latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
    }

    public void reset(int size) {
        this.latch = new CountDownLatch(size);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                CompletionLatchHandler.this.latch.countDown();
                nextListener.proceed();
            }
        });
        this.next.handleRequest(exchange);
    }
}

