/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import org.xnio.Buffers;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

public abstract class WebSocket07FrameSinkChannel
extends StreamSinkFrameChannel {
    private Pooled<ByteBuffer> start;
    private final int maskingKey;
    private final Masker masker;

    protected WebSocket07FrameSinkChannel(StreamSinkChannel channel, WebSocket07Channel wsChannel, WebSocketFrameType type, long payloadSize) {
        super(channel, wsChannel, type, payloadSize);
        if (wsChannel.isClient()) {
            this.maskingKey = new Random().nextInt();
            this.masker = new Masker(this.maskingKey);
        } else {
            this.masker = null;
            this.maskingKey = 0;
        }
    }

    private byte opCode() {
        switch (this.getType()) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(this.getType());
    }

    @Override
    protected ByteBuffer createFrameStart() {
        byte b0 = 0;
        if (this.isFinalFragment()) {
            b0 = (byte)(b0 | 0x80);
        }
        b0 = (byte)(b0 | (this.getRsv() & 7) << 4);
        b0 = (byte)(b0 | this.opCode() & 0xF);
        this.start = this.wsChannel.getBufferPool().allocate();
        ByteBuffer header = (ByteBuffer)this.start.getResource();
        int maskKey = 0;
        if (this.masker != null) {
            maskKey = (byte)(maskKey | 0x80);
        }
        if (this.payloadSize <= 125L) {
            header.put(b0);
            header.put((byte)((this.payloadSize | (long)maskKey) & 0xFFL));
        } else if (this.payloadSize <= 65535L) {
            header.put(b0);
            header.put((byte)((0x7E | maskKey) & 0xFF));
            header.put((byte)(this.payloadSize >>> 8 & 0xFFL));
            header.put((byte)(this.payloadSize & 0xFFL));
        } else {
            header.put(b0);
            header.put((byte)((0x7F | maskKey) & 0xFF));
            header.putLong(this.payloadSize);
        }
        if (this.masker != null) {
            header.put((byte)(this.maskingKey >> 24 & 0xFF));
            header.put((byte)(this.maskingKey >> 16 & 0xFF));
            header.put((byte)(this.maskingKey >> 8 & 0xFF));
            header.put((byte)(this.maskingKey & 0xFF));
        }
        return header;
    }

    @Override
    protected void frameStartComplete() {
        super.frameStartComplete();
        if (this.start != null) {
            this.start.free();
        }
    }

    @Override
    protected ByteBuffer createFrameEnd() {
        return Buffers.EMPTY_BYTE_BUFFER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.masker == null) {
            return super.write(srcs, offset, length);
        }
        Pooled buffer = this.wsChannel.getBufferPool().allocate();
        try {
            long written;
            ByteBuffer[] copy = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                copy[i] = srcs[offset + i].duplicate();
            }
            Buffers.copy((ByteBuffer)((ByteBuffer)buffer.getResource()), (ByteBuffer[])copy, (int)0, (int)length);
            ((ByteBuffer)buffer.getResource()).flip();
            this.masker.beforeWrite((ByteBuffer)buffer.getResource(), 0, ((ByteBuffer)buffer.getResource()).remaining());
            long toAllocate = written = super.write(new ByteBuffer[]{(ByteBuffer)buffer.getResource()}, 0, 1);
            for (int i = offset; i < length; ++i) {
                ByteBuffer thisBuf = srcs[i];
                if (toAllocate < (long)thisBuf.remaining()) {
                    thisBuf.position((int)((long)thisBuf.position() + toAllocate));
                    break;
                }
                toAllocate -= (long)thisBuf.remaining();
                thisBuf.position(thisBuf.limit());
            }
            long l = written;
            return l;
        }
        finally {
            buffer.free();
        }
    }

    @Override
    protected long transferFrom0(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)((Object)this));
    }
}

