/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.HttpClient;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientOptions;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpContinueAcceptingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.streams.ChannelInputStream;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class HttpClientTestCase {
    private static final String message = "Hello World!";
    private static XnioWorker worker;
    private static final OptionMap DEFAULT_OPTIONS;
    private static final HttpHandler SIMPLE_MESSAGE_HANDLER;
    private static final SocketAddress ADDRESS;

    static void sendMessage(HttpServerExchange exchange) {
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, message.length() + "");
        Sender sender = exchange.getResponseSender();
        sender.send(message);
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        XnioWorker xnioWorker;
        Xnio xnio = Xnio.getInstance();
        worker = xnioWorker = xnio.createWorker(null, DEFAULT_OPTIONS);
    }

    @AfterClass
    public static void afterClass() {
        worker.shutdown();
    }

    static HttpClient createClient() {
        return HttpClientTestCase.createClient(OptionMap.EMPTY);
    }

    static HttpClient createClient(OptionMap options) {
        return HttpClient.create((XnioWorker)worker, (OptionMap)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleBasic() throws Exception {
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        HttpClient client = HttpClientTestCase.createClient();
        try {
            HttpClientConnection connection = (HttpClientConnection)client.connect(ADDRESS, OptionMap.EMPTY).get();
            try {
                ArrayList<IoFuture> responses = new ArrayList<IoFuture>();
                for (int i = 0; i < 10; ++i) {
                    HttpClientRequest request = connection.createRequest(Methods.GET.toString(), new URI("/"));
                    responses.add(request.writeRequest());
                }
                Assert.assertEquals((long)10L, (long)responses.size());
                for (IoFuture future : responses) {
                    HttpClientResponse response = (HttpClientResponse)future.get();
                    StreamSourceChannel channel = response.readReplyBody();
                    try {
                        ChannelInputStream is = new ChannelInputStream(channel);
                        Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse((InputStream)is));
                    }
                    finally {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionClose() throws Exception {
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        HttpClient client = HttpClientTestCase.createClient();
        try {
            HttpClientConnection connection = (HttpClientConnection)client.connect(ADDRESS, OptionMap.EMPTY).get();
            try {
                HttpClientRequest request = connection.createRequest(Methods.GET, new URI("/1324"));
                request.getRequestHeaders().add(Headers.CONNECTION, Headers.CLOSE.toString());
                HttpClientResponse response = (HttpClientResponse)request.writeRequest().get();
                StreamSourceChannel channel = response.readReplyBody();
                try {
                    ChannelInputStream is = new ChannelInputStream(channel);
                    Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse((InputStream)is));
                }
                finally {
                    IoUtils.safeClose((Closeable)channel);
                }
                try {
                    connection.createRequest(Methods.GET, new URI("/1324")).writeRequest().get();
                    Assert.fail();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleHttpContinue() throws Exception {
        HttpContinueAcceptingHandler handler = new HttpContinueAcceptingHandler();
        DefaultServer.setRootHandler((HttpHandler)handler);
        HttpClient client = HttpClientTestCase.createClient();
        try {
            HttpClientConnection connection = (HttpClientConnection)client.connect(ADDRESS, OptionMap.EMPTY).get();
            try {
                HttpClientRequest request = connection.createRequest("POST", new URI("/"));
                request.getRequestHeaders().add(Headers.EXPECT, "100-continue");
                StreamSinkChannel channel = request.writeRequestBody((long)message.length());
                StringWriteChannelListener listener = new StringWriteChannelListener(message);
                listener.setup(channel);
                HttpClientResponse response = (HttpClientResponse)request.getResponse().get();
                Assert.assertEquals((long)404L, (long)response.getResponseCode());
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRejectHttpContinue() throws Exception {
        HttpContinueAcceptingHandler handler = new HttpContinueAcceptingHandler(){

            protected boolean acceptRequest(HttpServerExchange exchange) {
                return false;
            }
        };
        DefaultServer.setRootHandler((HttpHandler)handler);
        HttpClient client = HttpClientTestCase.createClient();
        try {
            HttpClientConnection connection = (HttpClientConnection)client.connect(ADDRESS, OptionMap.EMPTY).get();
            try {
                HttpClientRequest request = connection.createRequest("POST", new URI("/"));
                request.getRequestHeaders().add(Headers.EXPECT, "100-continue");
                StreamSinkChannel channel = request.writeRequestBody((long)message.length());
                StringWriteChannelListener listener = new StringWriteChannelListener(message);
                listener.setup(channel);
                HttpClientResponse response = (HttpClientResponse)request.getResponse().get();
                Assert.assertEquals((long)417L, (long)response.getResponseCode());
                Assert.assertTrue((boolean)listener.hasRemaining());
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpPipeline() throws Exception {
        OptionMap options = OptionMap.create((Option)HttpClientOptions.HTTP_PIPELINING, (Object)true);
        DefaultServer.setRootHandler(SIMPLE_MESSAGE_HANDLER);
        HttpClient client = HttpClientTestCase.createClient();
        try {
            HttpClientConnection connection = (HttpClientConnection)client.connect(ADDRESS, options).get();
            try {
                ArrayList<IoFuture> responses = new ArrayList<IoFuture>();
                for (int i = 0; i < 10; ++i) {
                    HttpClientRequest request = connection.createRequest(Methods.GET, new URI("/"));
                    responses.add(request.writeRequest());
                }
                Assert.assertEquals((long)10L, (long)responses.size());
                for (IoFuture future : responses) {
                    HttpClientResponse response = (HttpClientResponse)future.get();
                    StreamSourceChannel channel = response.readReplyBody();
                    try {
                        ChannelInputStream is = new ChannelInputStream(channel);
                        Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse((InputStream)is));
                    }
                    finally {
                        IoUtils.safeClose((Closeable)channel);
                    }
                }
            }
            finally {
                IoUtils.safeClose((Closeable)connection);
            }
        }
        finally {
            IoUtils.safeClose((Closeable)client);
        }
    }

    static {
        ADDRESS = DefaultServer.getDefaultServerAddress();
        OptionMap.Builder builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.KEEP_ALIVE, true).set(Options.WORKER_NAME, (Object)"Client");
        DEFAULT_OPTIONS = builder.getMap();
        SIMPLE_MESSAGE_HANDLER = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                HttpClientTestCase.sendMessage(exchange);
            }
        };
    }
}

