/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.accesslog;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AccessLogFileTestCase {
    private static final File logDirectory = new File(System.getProperty("java.io.tmpdir") + "/logs");
    private static final int NUM_THREADS = 10;
    private static final int NUM_REQUESTS = 12;
    private static final HttpHandler HELLO_HANDLER = new HttpHandler(){

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseSender().send("Hello");
        }
    };

    @Before
    public void before() {
        logDirectory.mkdirs();
    }

    @After
    public void after() {
        FileUtils.deleteRecursive((File)logDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleLogMessageToFile() throws IOException, InterruptedException {
        File directory = logDirectory;
        File logFileName = new File(directory, "server1.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server1");
        DefaultServer.setRootHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "Remote address %a Code %s test-header %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "single-val");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header single-val\n", (Object)FileUtils.readFile((File)logFileName));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogLotsOfThreads() throws IOException, InterruptedException, ExecutionException {
        File directory = logDirectory;
        File logFileName = new File(directory, "server2.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), directory, "server2");
        DefaultServer.setRootHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "REQ %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            ArrayList futures = new ArrayList();
            int i = 0;
            while (i < 10) {
                final int n = i++;
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        TestHttpClient client = new TestHttpClient();
                        try {
                            for (int i = 0; i < 12; ++i) {
                                HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
                                get.addHeader("test-header", "thread-" + n + "-request-" + i);
                                HttpResponse result = client.execute((HttpUriRequest)get);
                                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                                String response = HttpClientUtils.readResponse(result);
                                Assert.assertEquals((Object)"Hello", (Object)response);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            client.getConnectionManager().shutdown();
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executor.shutdown();
        }
        logReceiver.awaitWrittenForTest();
        String completeLog = FileUtils.readFile((File)logFileName);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 12; ++j) {
                Assert.assertTrue((boolean)completeLog.contains("REQ thread-" + i + "-request-" + j));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForcedLogRotation() throws IOException, InterruptedException {
        File logFileName = new File(logDirectory, "server.log");
        DefaultAccessLogReceiver logReceiver = new DefaultAccessLogReceiver((Executor)DefaultServer.getWorker(), logDirectory, "server");
        DefaultServer.setRootHandler((HttpHandler)new AccessLogHandler(HELLO_HANDLER, (AccessLogReceiver)logReceiver, "Remote address %a Code %s test-header %{i,test-header}", AccessLogFileTestCase.class.getClassLoader()));
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "v1");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header v1\n", (Object)FileUtils.readFile((File)logFileName));
            logReceiver.rotate();
            logReceiver.awaitWrittenForTest();
            Assert.assertFalse((boolean)logFileName.exists());
            File firstLogRotate = new File(logDirectory, "server_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".log");
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header v1\n", (Object)FileUtils.readFile((File)firstLogRotate));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.addHeader("test-header", "v2");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Hello", (Object)HttpClientUtils.readResponse(result));
            logReceiver.awaitWrittenForTest();
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header v2\n", (Object)FileUtils.readFile((File)logFileName));
            logReceiver.rotate();
            logReceiver.awaitWrittenForTest();
            Assert.assertFalse((boolean)logFileName.exists());
            File secondLogRotate = new File(logDirectory, "server_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "-1.log");
            Assert.assertEquals((Object)"Remote address 127.0.0.1 Code 200 test-header v2\n", (Object)FileUtils.readFile((File)secondLogRotate));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

