/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;

public class FileResourceManager
implements ResourceManager {
    private volatile String base;
    private final long transferMinSize;

    public FileResourceManager(File base, long transferMinSize) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        this.transferMinSize = transferMinSize;
    }

    public File getBase() {
        return new File(this.base);
    }

    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        this.base = basePath;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        String path = null;
        path = p.startsWith("/") ? p.substring(1) : p;
        try {
            File file = new File(this.base, path);
            if (file.exists() && file.getCanonicalFile().getName().equals(file.getName())) {
                return new FileResource(file, this, path);
            }
            return null;
        }
        catch (Exception e) {
            UndertowLogger.REQUEST_LOGGER.debugf(e, "Invalid path %s", new Object[0]);
            return null;
        }
    }

    public long getTransferMinSize() {
        return this.transferMinSize;
    }
}

