/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class BasicAuthenticationTestCase
extends AuthenticationTestBase {
    @Override
    protected AuthenticationMechanism getTestMechanism() {
        return new BasicAuthenticationMechanism("Test Realm");
    }

    @Test
    public void testBasicSuccess() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"userOne:passwordOne".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        this.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }

    @Test
    public void testBadUserName() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"badUser:passwordOne".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse(result);
        this.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }

    @Test
    public void testBadPassword() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        get = new HttpGet(DefaultServer.getDefaultServerURL());
        get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"userOne:badPassword".getBytes(), (boolean)false));
        result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        HttpClientUtils.readResponse(result);
        this.assertSingleNotificationType(SecurityNotification.EventType.FAILED_AUTHENTICATION);
    }
}

