/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class StreamSinkChannelAdapter
implements StreamSinkChannel {
    private final ChannelListener.SimpleSetter<? extends StreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<? extends StreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final WritableByteChannel channel;

    public StreamSinkChannelAdapter(WritableByteChannel channel) {
        this.channel = channel;
    }

    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = 0L;
        for (int i = offset; i < length; ++i) {
            int w = this.write(srcs[i]);
            if (w < 0) {
                return w;
            }
            written += (long)w;
        }
        return written;
    }

    public void suspendWrites() {
    }

    public void resumeWrites() {
    }

    public boolean isWriteResumed() {
        return false;
    }

    public void wakeupWrites() {
        throw new UnsupportedOperationException();
    }

    public void shutdownWrites() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void awaitWritable() throws IOException {
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
    }

    public XnioExecutor getWriteThread() {
        throw new UnsupportedOperationException();
    }

    public boolean flush() throws IOException {
        return true;
    }

    public XnioWorker getWorker() {
        throw new UnsupportedOperationException();
    }

    public XnioIoThread getIoThread() {
        return null;
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IOException {
        return null;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.channel);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long transfered = 0L;
        if (transfered < count) {
            int r = source.read(throughBuffer);
            if (r > 0) {
                throughBuffer.flip();
                while (throughBuffer.hasRemaining()) {
                    int w = this.write(throughBuffer);
                    if (w < 1) {
                        throughBuffer.flip();
                        return transfered;
                    }
                    transfered += (long)w;
                }
                throughBuffer.clear();
            }
            return transfered;
        }
        return transfered;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)0, (int)srcs.length);
    }
}

