/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class AbstractFramedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final Deque<Frame> frameQueue = new ArrayDeque<Frame>();
    private long queuedData = 0L;
    private int bufferCount = 0;
    private int state;
    private static final int FLAG_WRITES_TERMINATED = 1;
    private static final int FLAG_DELEGATE_SHUTDOWN = 2;

    protected AbstractFramedStreamSinkConduit(StreamSinkConduit next) {
        super(next);
    }

    protected void queueFrame(FrameCallBack callback, ByteBuffer ... data) {
        this.queuedData += Buffers.remaining((Buffer[])data);
        this.bufferCount += data.length;
        this.frameQueue.add(new Frame(callback, data, 0, data.length));
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return (int)this.doWrite(new ByteBuffer[]{src}, 0, 1);
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offs, (int)len);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        long res = this.doWrite(srcs, offs, len);
        if (!Buffers.hasRemaining((Buffer[])srcs, (int)offs, (int)len)) {
            this.terminateWrites();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doWrite(ByteBuffer[] additionalData, int offs, int len) throws IOException {
        ByteBuffer[] buffers = new ByteBuffer[this.bufferCount + (additionalData == null ? 0 : len)];
        int count = 0;
        for (Frame frame : this.frameQueue) {
            for (int i = frame.offs; i < frame.offs + frame.len; ++i) {
                buffers[count++] = frame.data[i];
            }
        }
        long totalData = this.queuedData;
        long userData = 0L;
        if (additionalData != null) {
            for (int i = offs; i < offs + len; ++i) {
                buffers[count++] = additionalData[i];
                userData += (long)additionalData[i].remaining();
            }
        }
        totalData += userData;
        try {
            long written = ((StreamSinkConduit)this.next).write(buffers, 0, buffers.length);
            this.queuedData = written > this.queuedData ? 0L : (this.queuedData -= written);
            long toAllocate = written;
            Frame frame = this.frameQueue.peek();
            while (frame != null) {
                if (frame.remaining > toAllocate) {
                    frame.remaining -= toAllocate;
                    return 0L;
                }
                this.frameQueue.poll();
                FrameCallBack cb = frame.callback;
                if (cb != null) {
                    cb.done();
                }
                this.bufferCount -= frame.len;
                toAllocate -= frame.remaining;
                frame = this.frameQueue.peek();
            }
            return toAllocate;
        }
        catch (IOException e) {
            try {
                for (Frame frame : this.frameQueue) {
                    FrameCallBack cb = frame.callback;
                    if (cb == null) continue;
                    cb.failed(e);
                }
                this.frameQueue.clear();
                this.bufferCount = 0;
                this.queuedData = 0L;
                return this.queuedData;
            }
            finally {
                throw e;
            }
        }
    }

    protected long queuedDataLength() {
        return this.queuedData;
    }

    public void terminateWrites() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        this.queueCloseFrames();
        this.state |= 1;
        if (this.queuedData == 0L) {
            this.state |= 2;
            this.doTerminateWrites();
            this.finished();
        }
    }

    protected void doTerminateWrites() throws IOException {
        ((StreamSinkConduit)this.next).terminateWrites();
    }

    public boolean flush() throws IOException {
        if (this.queuedData > 0L) {
            this.doWrite(null, 0, 0);
        }
        if (this.queuedData > 0L) {
            return false;
        }
        if (Bits.anyAreSet((int)this.state, (int)1) && Bits.allAreClear((int)this.state, (int)2)) {
            this.doTerminateWrites();
            this.state |= 2;
            this.finished();
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    public void truncateWrites() throws IOException {
        for (Frame frame : this.frameQueue) {
            FrameCallBack cb = frame.callback;
            if (cb == null) continue;
            cb.failed(UndertowMessages.MESSAGES.channelIsClosed());
        }
    }

    protected void queueCloseFrames() {
    }

    protected void finished() {
    }

    protected class PooledBuffersFrameCallback
    implements FrameCallBack {
        private final Pooled[] buffers;

        public PooledBuffersFrameCallback(Pooled ... buffers) {
            this.buffers = buffers;
        }

        @Override
        public void done() {
            for (Pooled buffer : this.buffers) {
                buffer.free();
            }
        }

        @Override
        public void failed(IOException e) {
            this.done();
        }
    }

    protected class PooledBufferFrameCallback
    implements FrameCallBack {
        private final Pooled<ByteBuffer> buffer;

        public PooledBufferFrameCallback(Pooled<ByteBuffer> buffer) {
            this.buffer = buffer;
        }

        @Override
        public void done() {
            this.buffer.free();
        }

        @Override
        public void failed(IOException e) {
            this.buffer.free();
        }
    }

    private class Frame {
        final FrameCallBack callback;
        final ByteBuffer[] data;
        final int offs;
        final int len;
        long remaining;

        private Frame(FrameCallBack callback, ByteBuffer[] data, int offs, int len) {
            this.callback = callback;
            this.data = data;
            this.offs = offs;
            this.len = len;
            this.remaining = Buffers.remaining((Buffer[])data, (int)offs, (int)len);
        }
    }

    public static interface FrameCallBack {
        public void done();

        public void failed(IOException var1);
    }
}

