/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

@Ignore(value="Requires XNIO release")
@RunWith(value=DefaultServer.class)
public class ClientCertRenegotiationTestCase
extends AuthenticationTestBase {
    private static SSLContext clientSSLContext;

    @Override
    protected AuthenticationMechanism getTestMechanism() {
        return new ClientCertAuthenticationMechanism();
    }

    @BeforeClass
    public static void startSSL() throws Exception {
        DefaultServer.startSSLServer(OptionMap.create((Option)Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.NOT_REQUESTED));
        clientSSLContext = DefaultServer.getClientSSLContext();
    }

    @AfterClass
    public static void stopSSL() throws Exception {
        clientSSLContext = null;
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testClientCertSuccess() throws Exception {
        this.setAuthenticationChain();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(clientSSLContext);
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((String)"ProcessedBy Headers", (long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        values = result.getHeaders("AuthenticatedUser");
        Assert.assertEquals((String)"AuthenticatedUser Headers", (long)1L, (long)values.length);
        Assert.assertEquals((Object)"CN=Test Client,OU=OU,O=Org,L=City,ST=State,C=GB", (Object)values[0].getValue());
        HttpClientUtils.readResponse(result);
        this.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
    }
}

