/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryParameterUtils {
    private QueryParameterUtils() {
    }

    public static String buildQueryString(Map<String, Deque<String>> params) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Deque<String>> entry : params.entrySet()) {
            if (entry.getValue().isEmpty()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                continue;
            }
            for (String val : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(val);
            }
        }
        return sb.toString();
    }

    public static Map<String, Deque<String>> parseQueryString(String newQueryString) {
        LinkedHashMap<String, Deque<String>> newQueryParameters = new LinkedHashMap<String, Deque<String>>();
        int startPos = 0;
        int equalPos = -1;
        for (int i = 0; i < newQueryString.length(); ++i) {
            char c = newQueryString.charAt(i);
            if (c == '=' && equalPos == -1) {
                equalPos = i;
                continue;
            }
            if (c != '&') continue;
            QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, i);
            startPos = i + 1;
            equalPos = -1;
        }
        if (startPos != newQueryString.length()) {
            QueryParameterUtils.handleQueryParameter(newQueryString, newQueryParameters, startPos, equalPos, newQueryString.length());
        }
        return newQueryParameters;
    }

    private static void handleQueryParameter(String newQueryString, Map<String, Deque<String>> newQueryParameters, int startPos, int equalPos, int i) {
        String key;
        String value = null;
        if (equalPos == -1) {
            key = newQueryString.substring(startPos, i);
        } else {
            key = newQueryString.substring(startPos, equalPos);
            value = newQueryString.substring(equalPos + 1, i);
        }
        Deque<String> queue = newQueryParameters.get(key);
        if (queue == null) {
            queue = new ArrayDeque<String>(1);
            newQueryParameters.put(key, queue);
        }
        queue.add(value);
    }

    public static Map<String, Deque<String>> mergeQueryParametersWithNewQueryString(Map<String, Deque<String>> queryParameters, String newQueryString) {
        Map<String, Deque<String>> newQueryParameters = QueryParameterUtils.parseQueryString(newQueryString);
        for (Map.Entry<String, Deque<String>> entry : queryParameters.entrySet()) {
            if (newQueryParameters.containsKey(entry.getKey())) continue;
            newQueryParameters.put(entry.getKey(), new ArrayDeque(entry.getValue()));
        }
        return newQueryParameters;
    }
}

