/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowOptions;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelListener;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.SslClientAuthMode;
import org.xnio.channels.Channels;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSourceChannel;

public class ConnectionSSLSessionInfo
implements SSLSessionInfo {
    private final SslChannel channel;
    private final HttpServerConnection serverConnection;

    public ConnectionSSLSessionInfo(SslChannel channel, HttpServerConnection serverConnection) {
        this.channel = channel;
        this.serverConnection = serverConnection;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        if (exchange.isRequestComplete()) {
            this.renegotiateNoRequest(exchange, sslClientAuthMode);
        } else {
            this.renegotiateBufferRequest(exchange, sslClientAuthMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateBufferRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        int allowedBuffers = exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_BUFFERS_FOR_BUFFERED_REQUEST, 1);
        if (allowedBuffers <= 0) {
            throw new SSLPeerUnverifiedException("");
        }
        boolean requestResetRequired = false;
        StreamSourceChannel requestChannel = Connectors.getExistingRequestChannel(exchange);
        if (requestChannel == null) {
            requestChannel = exchange.getRequestChannel();
            requestResetRequired = true;
        }
        Pooled pooled = null;
        boolean free = true;
        int usedBuffers = 0;
        Pooled[] poolArray = null;
        poolArray = new Pooled[allowedBuffers];
        pooled = exchange.getConnection().getBufferPool().allocate();
        poolArray[usedBuffers++] = pooled;
        boolean dataRead = false;
        try {
            int res;
            do {
                ByteBuffer buf = (ByteBuffer)pooled.getResource();
                res = Channels.readBlocking((ReadableByteChannel)requestChannel, (ByteBuffer)buf);
                if (buf.hasRemaining()) continue;
                if (usedBuffers == allowedBuffers) {
                    throw new SSLPeerUnverifiedException("");
                }
                buf.flip();
                pooled = exchange.getConnection().getBufferPool().allocate();
                poolArray[usedBuffers++] = pooled;
            } while (res != -1);
            free = false;
            ((ByteBuffer)pooled.getResource()).flip();
            Connectors.ungetRequestBytes(exchange, poolArray);
            this.renegotiateNoRequest(exchange, newAuthMode);
        }
        finally {
            if (free) {
                for (Pooled buf : poolArray) {
                    if (buf == null) continue;
                    buf.free();
                }
            }
            if (requestResetRequired) {
                exchange.requestChannel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renegotiateNoRequest(HttpServerExchange exchange, SslClientAuthMode newAuthMode) throws IOException {
        AbstractServerConnection.ConduitState oldState = this.serverConnection.resetChannel();
        try {
            SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
            if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                SslHandshakeWaiter waiter = new SslHandshakeWaiter();
                this.channel.getHandshakeSetter().set((ChannelListener)waiter);
                this.channel.setOption(Options.SSL_CLIENT_AUTH_MODE, (Object)newAuthMode);
                this.channel.getSslSession().invalidate();
                this.channel.startHandshake();
                ByteBuffer buff = ByteBuffer.wrap(new byte[1]);
                while (!waiter.isDone() && this.serverConnection.isOpen()) {
                    int read = this.serverConnection.getSourceChannel().read(buff);
                    if (read != 0) {
                        throw new SSLPeerUnverifiedException("");
                    }
                    if (waiter.isDone()) continue;
                    this.serverConnection.getSourceChannel().awaitReadable();
                }
            }
        }
        finally {
            if (oldState != null) {
                this.serverConnection.restoreChannel(oldState);
            }
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static class SslHandshakeWaiter
    implements ChannelListener<SslChannel> {
        private volatile boolean done = false;

        private SslHandshakeWaiter() {
        }

        boolean isDone() {
            return this.done;
        }

        public void handleEvent(SslChannel channel) {
            this.done = true;
        }
    }
}

