/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.server.HttpHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.NetworkUtils;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true)
public class AbstractWebSocketServerTest {
    @Test
    public void testText() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(final WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(final WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                            if (ws == null) {
                                return;
                            }
                            new StringReadChannelListener(exchange.getBufferPool()){

                                protected void stringDone(String string) {
                                    try {
                                        if (string.equals("hello")) {
                                            new StringWriteChannelListener("world").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"world".length()));
                                        } else {
                                            new StringWriteChannelListener(string).setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)string.length()));
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        throw new RuntimeException(e);
                                    }
                                }

                                protected void error(IOException e) {
                                    try {
                                        e.printStackTrace();
                                        new StringWriteChannelListener("ERROR").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"ERROR".length()));
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                        throw new RuntimeException(ex);
                                    }
                                }
                            }.setup((StreamSourceChannel)ws);
                            channel.getReceiveSetter().set(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        AtomicReference result = new AtomicReference();
        FutureResult latch = new FutureResult();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(ChannelBuffers.copiedBuffer((CharSequence)"hello", (Charset)CharsetUtil.US_ASCII)), new FrameChecker(TextWebSocketFrame.class, "world".getBytes(CharsetUtil.US_ASCII), latch));
        latch.getIoFuture().get();
        client.destroy();
    }

    @Test
    public void testBinary() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                            if (ws == null) {
                                return;
                            }
                            Assert.assertEquals((Object)WebSocketFrameType.BINARY, (Object)ws.getType());
                            ByteBuffer buf = ByteBuffer.allocate(32);
                            while (ws.read(buf) != -1) {
                            }
                            buf.flip();
                            StreamSinkFrameChannel sink = channel.send(WebSocketFrameType.BINARY, (long)buf.remaining());
                            Assert.assertEquals((Object)WebSocketFrameType.BINARY, (Object)sink.getType());
                            while (buf.hasRemaining()) {
                                sink.write(buf);
                            }
                            sink.shutdownWrites();
                            if (!sink.flush()) {
                                sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                sink.resumeWrites();
                            }
                            channel.getReceiveSetter().set(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        byte[] payload = "payload".getBytes();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)), new FrameChecker(BinaryWebSocketFrame.class, payload, latch));
        latch.getIoFuture().get();
        client.destroy();
    }

    @Test
    public void testCloseFrame() throws Exception {
        if (this.getVersion() == WebSocketVersion.V00) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                            if (ws == null) {
                                return;
                            }
                            Assert.assertEquals((Object)WebSocketFrameType.CLOSE, (Object)ws.getType());
                            channel.close();
                            channel.getReceiveSetter().set(null);
                            latch.countDown();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        final AtomicBoolean receivedResponse = new AtomicBoolean(false);
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ":" + DefaultServer.getHostPort("default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new CloseWebSocketFrame(), new WebSocketTestClient.FrameListener(){

            @Override
            public void onFrame(WebSocketFrame frame) {
                receivedResponse.set(true);
            }

            @Override
            public void onError(Throwable t) {
                t.printStackTrace();
            }
        });
        latch.await();
        Assert.assertFalse((boolean)receivedResponse.get());
        client.destroy();
    }

    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V00;
    }
}

