/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.conduits.WriteReadyHandler;

public class IdleTimeoutConduit
implements StreamSinkConduit,
StreamSourceConduit {
    private volatile XnioExecutor.Key handle;
    private static final AtomicReferenceFieldUpdater<IdleTimeoutConduit, XnioExecutor.Key> KEY_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IdleTimeoutConduit.class, XnioExecutor.Key.class, "handle");
    private volatile long idleTimeout;
    private final StreamSinkConduit sink;
    private final StreamSourceConduit source;
    private volatile WriteReadyHandler writeReadyHandler;
    private volatile ReadReadyHandler readReadyHandler;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            IdleTimeoutConduit.safeClose(IdleTimeoutConduit.this.sink);
            IdleTimeoutConduit.safeClose(IdleTimeoutConduit.this.source);
            if (IdleTimeoutConduit.this.sink.isWriteResumed() && IdleTimeoutConduit.this.writeReadyHandler != null) {
                IdleTimeoutConduit.this.writeReadyHandler.writeReady();
            }
            if (IdleTimeoutConduit.this.source.isReadResumed() && IdleTimeoutConduit.this.readReadyHandler != null) {
                IdleTimeoutConduit.this.readReadyHandler.readReady();
            }
        }
    };

    public IdleTimeoutConduit(StreamSinkConduit sink, StreamSourceConduit source) {
        this.sink = sink;
        this.source = source;
    }

    private void handleIdleTimeout() {
        XnioExecutor.Key k;
        long idleTimeout = this.idleTimeout;
        XnioExecutor.Key key = this.handle;
        if (key != null) {
            key.remove();
        }
        if (idleTimeout > 0L && !KEY_UPDATER.compareAndSet(this, key, k = this.sink.getWriteThread().executeAfter(this.timeoutCommand, idleTimeout, TimeUnit.MILLISECONDS))) {
            k.remove();
        }
    }

    public int write(ByteBuffer src) throws IOException {
        int w = this.sink.write(src);
        this.handleIdleTimeout();
        return w;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long w = this.sink.write(srcs, offset, length);
        this.handleIdleTimeout();
        return w;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long w = this.source.transferTo(position, count, target);
        this.handleIdleTimeout();
        return w;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long w = this.source.transferTo(count, throughBuffer, target);
        this.handleIdleTimeout();
        return w;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long r = this.source.read(dsts, offset, length);
        this.handleIdleTimeout();
        return r;
    }

    public int read(ByteBuffer dst) throws IOException {
        int r = this.source.read(dst);
        this.handleIdleTimeout();
        return r;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long r = this.sink.transferFrom(src, position, count);
        this.handleIdleTimeout();
        return r;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long r = this.sink.transferFrom(source, count, throughBuffer);
        this.handleIdleTimeout();
        return r;
    }

    public void suspendReads() {
        this.source.suspendReads();
    }

    public void terminateReads() throws IOException {
        this.source.terminateReads();
    }

    public boolean isReadShutdown() {
        return this.source.isReadShutdown();
    }

    public void resumeReads() {
        this.source.resumeReads();
    }

    public boolean isReadResumed() {
        return this.source.isReadResumed();
    }

    public void wakeupReads() {
        this.source.wakeupReads();
    }

    public void awaitReadable() throws IOException {
        this.source.awaitReadable();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.source.awaitReadable(time, timeUnit);
    }

    public XnioIoThread getReadThread() {
        return this.source.getReadThread();
    }

    public void setReadReadyHandler(ReadReadyHandler handler) {
        this.readReadyHandler = handler;
        this.source.setReadReadyHandler(handler);
    }

    private static void safeClose(StreamSourceConduit sink) {
        try {
            sink.terminateReads();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void safeClose(StreamSinkConduit sink) {
        try {
            sink.truncateWrites();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void terminateWrites() throws IOException {
        this.sink.terminateWrites();
    }

    public boolean isWriteShutdown() {
        return this.sink.isWriteShutdown();
    }

    public void resumeWrites() {
        this.sink.resumeWrites();
    }

    public void suspendWrites() {
        this.sink.suspendWrites();
    }

    public void wakeupWrites() {
        this.sink.wakeupWrites();
    }

    public boolean isWriteResumed() {
        return this.sink.isWriteResumed();
    }

    public void awaitWritable() throws IOException {
        this.sink.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.sink.awaitWritable();
    }

    public XnioIoThread getWriteThread() {
        return this.sink.getWriteThread();
    }

    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
        this.sink.setWriteReadyHandler(handler);
    }

    public void truncateWrites() throws IOException {
        this.sink.truncateWrites();
    }

    public boolean flush() throws IOException {
        return this.sink.flush();
    }

    public XnioWorker getWorker() {
        return this.sink.getWorker();
    }
}

