/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.attribute.CompositeExchangeAttribute;
import io.undertow.attribute.ConstantExchangeAttribute;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class ExchangeAttributeParser {
    private final List<ExchangeAttributeBuilder> builders;

    ExchangeAttributeParser(ClassLoader classLoader) {
        ServiceLoader<ExchangeAttributeBuilder> loader = ServiceLoader.load(ExchangeAttributeBuilder.class, classLoader);
        ArrayList<ExchangeAttributeBuilder> builders = new ArrayList<ExchangeAttributeBuilder>();
        for (ExchangeAttributeBuilder instance : loader) {
            builders.add(instance);
        }
        this.builders = Collections.unmodifiableList(builders);
    }

    public ExchangeAttribute parse(String valueString) {
        ArrayList<ExchangeAttribute> attributes = new ArrayList<ExchangeAttribute>();
        int pos = 0;
        int state = 0;
        block11: for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '%' && c != '$') continue block11;
                    if (pos != i) {
                        attributes.add(this.parseSingleToken(valueString.substring(pos, i)));
                        pos = i;
                    }
                    if (c == '%') {
                        state = 1;
                        continue block11;
                    }
                    state = 3;
                    continue block11;
                }
                case 1: {
                    if (c == '{') {
                        state = 2;
                        continue block11;
                    }
                    if (c == '%') {
                        attributes.add(new ConstantExchangeAttribute("%"));
                        pos = i + 1;
                        state = 0;
                        continue block11;
                    }
                    attributes.add(this.parseSingleToken(valueString.substring(pos, i + 1)));
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
                case 2: {
                    if (c != '}') continue block11;
                    attributes.add(this.parseSingleToken(valueString.substring(pos, i + 1)));
                    pos = i + 1;
                    state = 0;
                    continue block11;
                }
                case 3: {
                    if (c == '{') {
                        state = 4;
                        continue block11;
                    }
                    state = 0;
                    continue block11;
                }
                case 4: {
                    if (c != '}') continue block11;
                    attributes.add(this.parseSingleToken(valueString.substring(pos, i + 1)));
                    pos = i + 1;
                    state = 0;
                }
            }
        }
        switch (state) {
            case 0: 
            case 1: 
            case 3: {
                if (pos == valueString.length()) break;
                attributes.add(this.parseSingleToken(valueString.substring(pos)));
                break;
            }
            case 2: 
            case 4: {
                throw UndertowMessages.MESSAGES.mismatchedBraces(valueString);
            }
        }
        if (attributes.size() == 1) {
            return (ExchangeAttribute)attributes.get(0);
        }
        return new CompositeExchangeAttribute(attributes.toArray(new ExchangeAttribute[attributes.size()]));
    }

    public ExchangeAttribute parseSingleToken(String token) {
        for (ExchangeAttributeBuilder builder : this.builders) {
            ExchangeAttribute res = builder.build(token);
            if (res == null) continue;
            return res;
        }
        if (token.startsWith("%")) {
            UndertowLogger.ROOT_LOGGER.unkownVariable(token);
        }
        return new ConstantExchangeAttribute(token);
    }
}

