/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.ProxiedRequestAttachments;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Certificates;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.nio.channels.Channel;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class ProxyHandler
implements HttpHandler {
    public static final String UTF_8 = "UTF-8";
    private final ProxyClient proxyClient;
    private final int maxRequestTime;
    private static final AttachmentKey<ProxyConnection> CONNECTION = AttachmentKey.create(ProxyConnection.class);
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    private static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final ProxyClientHandler proxyClientHandler = new ProxyClientHandler();
    private final Map<HttpString, ExchangeAttribute> requestHeaders = new CopyOnWriteMap<HttpString, ExchangeAttribute>();
    private final HttpHandler next;

    public ProxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next) {
        this.proxyClient = proxyClient;
        this.maxRequestTime = maxRequestTime;
        this.next = next;
    }

    public ProxyHandler(ProxyClient proxyClient, HttpHandler next) {
        this.proxyClient = proxyClient;
        this.next = next;
        this.maxRequestTime = -1;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        final ProxyClient.ProxyTarget target = this.proxyClient.findTarget(exchange);
        if (target == null) {
            this.next.handleRequest(exchange);
            return;
        }
        if (this.maxRequestTime > 0) {
            final XnioExecutor.Key key = exchange.getIoThread().executeAfter(new Runnable(){

                @Override
                public void run() {
                    ProxyConnection connectionAttachment = (ProxyConnection)exchange.getAttachment(CONNECTION);
                    if (connectionAttachment != null) {
                        ClientConnection clientConnection = connectionAttachment.getConnection();
                        IoUtils.safeClose((Closeable)clientConnection);
                    } else {
                        exchange.setResponseCode(503);
                        exchange.endExchange();
                    }
                }
            }, (long)this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    key.remove();
                    nextListener.proceed();
                }
            });
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                ProxyHandler.this.proxyClient.getConnection(target, exchange, ProxyHandler.this.proxyClientHandler, -1L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public ProxyHandler addRequestHeader(HttpString header, ExchangeAttribute attribute) {
        this.requestHeaders.put(header, attribute);
        return this;
    }

    public ProxyHandler addRequestHeader(HttpString header, String attribute, ClassLoader classLoader) {
        this.requestHeaders.put(header, ExchangeAttributes.parser(classLoader).parse(attribute));
        return this;
    }

    public ProxyHandler removeRequestHeader(HttpString header) {
        this.requestHeaders.remove(header);
        return this;
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            to.putAll(values.getHeaderName(), values);
            f = from.fiNextNonEmpty(f);
        }
    }

    public ProxyClient getProxyClient() {
        return this.proxyClient;
    }

    private static String encodeUrlPart(String part) throws UnsupportedEncodingException {
        int pos = 0;
        for (int i = 0; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c == '/') {
                String original;
                String encoded;
                if (pos != i && !(encoded = URLEncoder.encode(original = part.substring(pos, i - 1), UTF_8)).equals(original)) {
                    return ProxyHandler.realEncode(part, pos);
                }
                pos = i + 1;
                continue;
            }
            if (c != ' ') continue;
            return ProxyHandler.realEncode(part, pos);
        }
        return part;
    }

    private static String realEncode(String part, int startPos) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append(part.substring(0, startPos));
        int pos = startPos;
        for (int i = startPos; i < part.length(); ++i) {
            char c = part.charAt(i);
            if (c != '/' || pos == i) continue;
            String original = part.substring(pos, i - 1);
            String encoded = URLEncoder.encode(original, UTF_8);
            sb.append(encoded);
            sb.append('/');
            pos = i + 1;
        }
        String original = part.substring(pos);
        String encoded = URLEncoder.encode(original, UTF_8);
        sb.append(encoded);
        return sb.toString();
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        public void handleException(Channel channel, IOException exception) {
            if (this.exchange.isResponseStarted()) {
                IoUtils.safeClose((Closeable)this.clientConnection);
                UndertowLogger.REQUEST_IO_LOGGER.debug("Exception reading from target server", exception);
                if (!this.exchange.isResponseStarted()) {
                    this.exchange.setResponseCode(500);
                    this.exchange.endExchange();
                } else {
                    IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
                }
            } else {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            }
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(ChunkedStreamSourceConduit.TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(ChunkedStreamSinkConduit.TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                        public void handleEvent(StreamSinkChannel channel) {
                            channel.suspendWrites();
                            channel.getWriteSetter().set(null);
                        }
                    }, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                } else {
                    channel.getWriteSetter().set(null);
                    channel.shutdownWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;

        private ResponseCallback(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientExchange result) {
            HttpServerExchange exchange = (HttpServerExchange)result.getAttachment(EXCHANGE);
            ClientResponse response = result.getResponse();
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = exchange.getResponseHeaders();
            exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (exchange.isPersistent() && !result.getConnection().isOpen()) {
                outboundResponseHeaders.put(Headers.CONNECTION, "keep-alive");
            }
            if (exchange.isUpgrade()) {
                exchange.upgradeChannel(new HttpUpgradeListener(){

                    @Override
                    public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                        StreamConnection clientChannel = null;
                        try {
                            clientChannel = result.getConnection().performUpgrade();
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)clientChannel.getSourceChannel(), (StreamSinkChannel)streamConnection.getSinkChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), result.getConnection().getBufferPool());
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)streamConnection.getSourceChannel(), (StreamSinkChannel)clientChannel.getSinkChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), result.getConnection().getBufferPool());
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable[])new Closeable[]{streamConnection, clientChannel});
                        }
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(exchange, result.getConnection());
            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)result.getResponseChannel(), (StreamSinkChannel)exchange.getResponseChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(result, exchange), (ChannelExceptionHandler)handler, (ChannelExceptionHandler)handler, exchange.getConnection().getBufferPool());
        }

        @Override
        public void failed(IOException e) {
            if (!this.exchange.isResponseStarted()) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            } else {
                IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            }
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ProxyConnection clientConnection;
        private final HttpServerExchange exchange;
        private final Map<HttpString, ExchangeAttribute> requestHeaders;

        public ProxyAction(ProxyConnection clientConnection, HttpServerExchange exchange, Map<HttpString, ExchangeAttribute> requestHeaders) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
            this.requestHeaders = requestHeaders;
        }

        @Override
        public void run() {
            SSLSessionInfo sslSessionInfo;
            ClientRequest request = new ClientRequest();
            StringBuilder requestURI = new StringBuilder();
            try {
                String qs;
                if (this.exchange.getRelativePath().isEmpty()) {
                    requestURI.append(ProxyHandler.encodeUrlPart(this.clientConnection.getTargetPath()));
                } else if (this.clientConnection.getTargetPath().endsWith("/")) {
                    requestURI.append(this.clientConnection.getTargetPath().substring(0, this.clientConnection.getTargetPath().length() - 1));
                    requestURI.append(ProxyHandler.encodeUrlPart(this.exchange.getRelativePath()));
                } else {
                    requestURI = requestURI.append(this.clientConnection.getTargetPath());
                    requestURI.append(ProxyHandler.encodeUrlPart(this.exchange.getRelativePath()));
                }
                boolean first = true;
                if (!this.exchange.getPathParameters().isEmpty()) {
                    requestURI.append(';');
                    for (Map.Entry<String, Deque<String>> entry : this.exchange.getPathParameters().entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            requestURI.append('&');
                        }
                        for (String val : entry.getValue()) {
                            requestURI.append(URLEncoder.encode(entry.getKey(), ProxyHandler.UTF_8));
                            requestURI.append('=');
                            requestURI.append(URLEncoder.encode(val, ProxyHandler.UTF_8));
                        }
                    }
                }
                if ((qs = this.exchange.getQueryString()) != null && !qs.isEmpty()) {
                    requestURI.append('?');
                    requestURI.append(qs);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
                return;
            }
            request.setPath(requestURI.toString()).setMethod(this.exchange.getRequestMethod());
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            for (Map.Entry<HttpString, ExchangeAttribute> entry : this.requestHeaders.entrySet()) {
                String headerValue = entry.getValue().readAttribute(this.exchange);
                if (headerValue == null || headerValue.isEmpty()) {
                    outboundRequestHeaders.remove(entry.getKey());
                    continue;
                }
                outboundRequestHeaders.put(entry.getKey(), headerValue.replace('\n', ' '));
            }
            SocketAddress address = this.exchange.getConnection().getPeerAddress();
            if (address instanceof InetSocketAddress) {
                outboundRequestHeaders.put(Headers.X_FORWARDED_FOR, ((InetSocketAddress)address).getHostString());
            } else {
                outboundRequestHeaders.put(Headers.X_FORWARDED_FOR, "localhost");
            }
            if (this.exchange.getRequestScheme().equals("https")) {
                request.putAttachment(ProxiedRequestAttachments.IS_SSL, true);
            }
            if ((sslSessionInfo = this.exchange.getConnection().getSslSessionInfo()) != null) {
                try {
                    X509Certificate[] peerCertificates = sslSessionInfo.getPeerCertificateChain();
                    if (peerCertificates.length > 0) {
                        request.putAttachment(ProxiedRequestAttachments.SSL_CERT, Certificates.toPem(peerCertificates[0]));
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                }
                catch (CertificateEncodingException e) {
                }
                catch (RenegotiationRequiredException e) {
                    // empty catch block
                }
                request.putAttachment(ProxiedRequestAttachments.SSL_CYPHER, sslSessionInfo.getCipherSuite());
                request.putAttachment(ProxiedRequestAttachments.SSL_SESSION_ID, sslSessionInfo.getSessionId());
            }
            this.clientConnection.getConnection().sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    result.putAttachment(EXCHANGE, ProxyAction.this.exchange);
                    if (HttpContinue.requiresContinueResponse(ProxyAction.this.exchange)) {
                        result.setContinueHandler(new ContinueNotification(){

                            @Override
                            public void handleContinue(ClientExchange clientExchange) {
                                HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                                    @Override
                                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                                    }

                                    @Override
                                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                        IoUtils.safeClose((Closeable)ProxyAction.this.clientConnection.getConnection());
                                    }
                                });
                            }
                        });
                    }
                    result.setResponseListener(new ResponseCallback(ProxyAction.this.exchange));
                    IoExceptionHandler handler = new IoExceptionHandler(ProxyAction.this.exchange, ProxyAction.this.clientConnection.getConnection());
                    ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)ProxyAction.this.exchange.getRequestChannel(), (StreamSinkChannel)result.getRequestChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(ProxyAction.this.exchange, result), (ChannelExceptionHandler)handler, (ChannelExceptionHandler)handler, ProxyAction.this.exchange.getConnection().getBufferPool());
                }

                @Override
                public void failed(IOException e) {
                    if (!ProxyAction.this.exchange.isResponseStarted()) {
                        ProxyAction.this.exchange.setResponseCode(503);
                        ProxyAction.this.exchange.endExchange();
                    } else {
                        IoUtils.safeClose((Closeable)((Object)ProxyAction.this.exchange.getConnection()));
                    }
                }
            });
        }
    }

    private final class ProxyClientHandler
    implements ProxyCallback<ProxyConnection> {
        private ProxyClientHandler() {
        }

        @Override
        public void completed(HttpServerExchange exchange, ProxyConnection result) {
            exchange.putAttachment(CONNECTION, result);
            exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(result, exchange, ProxyHandler.this.requestHeaders));
        }

        @Override
        public void failed(HttpServerExchange exchange) {
            if (!exchange.isResponseStarted()) {
                exchange.setResponseCode(500);
                exchange.endExchange();
            } else {
                IoUtils.safeClose((Closeable)((Object)exchange.getConnection()));
            }
        }
    }
}

