/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CompletionLatchHandler
implements HttpHandler {
    private final HttpHandler next;
    private volatile CountDownLatch latch = new CountDownLatch(1);

    public CompletionLatchHandler(HttpHandler next) {
        this.next = next;
    }

    public void await() {
        try {
            this.latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                CompletionLatchHandler.this.latch.countDown();
                nextListener.proceed();
            }
        });
        this.next.handleRequest(exchange);
    }
}

