/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.UTF8Output;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class BufferedTextMessage {
    private final UTF8Output data = new UTF8Output();
    private final long maxMessageSize;
    long currentSize;

    public BufferedTextMessage(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public BufferedTextMessage() {
        this(-1L);
    }

    private void checkMaxSize(StreamSourceFrameChannel channel, int res) throws IOException {
        this.currentSize += (long)res;
        if (this.maxMessageSize > 0L && this.currentSize > this.maxMessageSize) {
            WebSockets.sendClose(new CloseMessage(1009, WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize)).toByteBuffer(), channel.getWebSocketChannel(), null);
            throw new IOException(WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize));
        }
    }

    public void readBlocking(StreamSourceFrameChannel channel) throws IOException {
        Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    return;
                }
                if (res == 0) {
                    channel.awaitReadable();
                }
                this.checkMaxSize(channel, res);
                buffer.flip();
                this.data.write(buffer);
                buffer.compact();
            }
        }
        finally {
            pooled.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(StreamSourceFrameChannel channel, final WebSocketCallback<BufferedTextMessage> callback) {
        Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        try {
            while (true) {
                int res;
                if ((res = channel.read(buffer)) == -1) {
                    callback.complete(channel.getWebSocketChannel(), this);
                    return;
                }
                if (res == 0) {
                    channel.getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceFrameChannel>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void handleEvent(StreamSourceFrameChannel channel) {
                            Pooled pooled = channel.getWebSocketChannel().getBufferPool().allocate();
                            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                            try {
                                while (true) {
                                    int res;
                                    if ((res = channel.read(buffer)) == -1) {
                                        callback.complete(channel.getWebSocketChannel(), BufferedTextMessage.this);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    BufferedTextMessage.this.checkMaxSize(channel, res);
                                    buffer.flip();
                                    BufferedTextMessage.this.data.write(buffer);
                                    buffer.compact();
                                    continue;
                                    break;
                                }
                            }
                            catch (IOException e) {
                                callback.onError(channel.getWebSocketChannel(), BufferedTextMessage.this, e);
                                return;
                            }
                            finally {
                                pooled.free();
                            }
                        }
                    });
                    channel.resumeReads();
                    return;
                }
                this.checkMaxSize(channel, res);
                buffer.flip();
                this.data.write(buffer);
                buffer.compact();
                continue;
                break;
            }
        }
        catch (IOException e) {
            callback.onError(channel.getWebSocketChannel(), this, e);
            return;
        }
        finally {
            pooled.free();
        }
    }

    public String getData() {
        return this.data.extract();
    }
}

