/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ConduitListener;
import io.undertow.conduits.FinishableStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSinkConduit;
import io.undertow.conduits.FixedLengthStreamSourceConduit;
import io.undertow.conduits.HeadStreamSinkConduit;
import io.undertow.conduits.PipelingBufferingStreamSinkConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpResponseConduit;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import org.jboss.logging.Logger;
import org.xnio.XnioExecutor;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class HttpTransferEncoding {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.handler.transfer-encoding");

    private HttpTransferEncoding() {
    }

    public static void handleRequest(HttpServerExchange exchange, HttpHandler next) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String connectionHeader = requestHeaders.getFirst(Headers.CONNECTION);
        String transferEncodingHeader = requestHeaders.getLast(Headers.TRANSFER_ENCODING);
        String contentLengthHeader = requestHeaders.getFirst(Headers.CONTENT_LENGTH);
        HttpServerConnection connection = exchange.getConnection();
        ConduitStreamSinkChannel sinkChannel = connection.getChannel().getSinkChannel();
        PipelingBufferingStreamSinkConduit pipeliningBuffer = connection.getAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY);
        if (pipeliningBuffer != null) {
            pipeliningBuffer.setupPipelineBuffer(exchange);
        }
        ConduitStreamSourceChannel sourceChannel = connection.getChannel().getSourceChannel();
        sourceChannel.setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(sourceChannel.getConduit(), connection));
        boolean persistentConnection = HttpTransferEncoding.persistentConnection(exchange, connectionHeader);
        if (exchange.getRequestMethod().equals(Methods.GET)) {
            if (persistentConnection && connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(connection.getOriginalSinkConduit(), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                pipeliningBuffer.setupPipelineBuffer(exchange);
            }
            exchange.terminateRequest();
        } else {
            persistentConnection = HttpTransferEncoding.handleRequestEncoding(exchange, transferEncodingHeader, contentLengthHeader, connection, pipeliningBuffer, persistentConnection);
        }
        exchange.setPersistent(persistentConnection);
        sinkChannel.setConduit((StreamSinkConduit)new HttpResponseConduit(sinkChannel.getConduit(), connection.getBufferPool(), exchange));
        exchange.addResponseWrapper(HttpTransferEncoding.responseWrapper(persistentConnection));
        HttpHandlers.executeRootHandler(next, exchange, Thread.currentThread() instanceof XnioExecutor);
    }

    private static boolean handleRequestEncoding(HttpServerExchange exchange, String transferEncodingHeader, String contentLengthHeader, HttpServerConnection connection, PipelingBufferingStreamSinkConduit pipeliningBuffer, boolean persistentConnection) {
        HttpString transferEncoding = Headers.IDENTITY;
        if (transferEncodingHeader != null) {
            transferEncoding = new HttpString(transferEncodingHeader);
        }
        if (transferEncodingHeader != null && !transferEncoding.equals(Headers.IDENTITY)) {
            ConduitStreamSourceChannel sourceChannel = exchange.getConnection().getChannel().getSourceChannel();
            sourceChannel.setConduit((StreamSourceConduit)new ChunkedStreamSourceConduit(sourceChannel.getConduit(), exchange, HttpTransferEncoding.chunkedDrainListener(exchange)));
        } else if (contentLengthHeader != null) {
            long contentLength = Long.parseLong(contentLengthHeader);
            if (contentLength == 0L) {
                log.trace((Object)"No content, starting next request");
                exchange.terminateRequest();
            } else {
                ConduitStreamSourceChannel sourceChannel = exchange.getConnection().getChannel().getSourceChannel();
                sourceChannel.setConduit(HttpTransferEncoding.fixedLengthStreamSourceConduitWrapper(contentLength, sourceChannel.getConduit(), exchange));
            }
        } else if (transferEncodingHeader != null) {
            if (transferEncoding.equals(Headers.IDENTITY)) {
                log.trace((Object)"Connection not persistent (no content length and identity transfer encoding)");
                persistentConnection = false;
            }
        } else if (persistentConnection) {
            if (connection.getExtraBytes() != null && pipeliningBuffer == null && connection.getUndertowOptions().get(UndertowOptions.BUFFER_PIPELINED_DATA, false)) {
                pipeliningBuffer = new PipelingBufferingStreamSinkConduit(connection.getOriginalSinkConduit(), connection.getBufferPool());
                connection.putAttachment(PipelingBufferingStreamSinkConduit.ATTACHMENT_KEY, pipeliningBuffer);
                pipeliningBuffer.setupPipelineBuffer(exchange);
            }
            exchange.terminateRequest();
        } else if (exchange.isHttp11()) {
            exchange.terminateRequest();
        }
        return persistentConnection;
    }

    private static boolean persistentConnection(HttpServerExchange exchange, String connectionHeader) {
        if (exchange.isHttp11()) {
            return connectionHeader == null || !new HttpString(connectionHeader).equals(Headers.CLOSE);
        }
        if (exchange.isHttp10() && connectionHeader != null && Headers.KEEP_ALIVE.equals(new HttpString(connectionHeader))) {
            return true;
        }
        log.trace((Object)"Connection not persistent");
        return false;
    }

    private static ConduitWrapper<StreamSinkConduit> responseWrapper(final boolean requestLooksPersistent) {
        return new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                AbstractStreamSinkConduit wrappedConduit;
                if (exchange.getRequestMethod().equals(Methods.HEAD)) {
                    return new HeadStreamSinkConduit(factory.create(), HttpTransferEncoding.terminateResponseListener(exchange));
                }
                StreamSinkConduit channel = factory.create();
                HeaderMap responseHeaders = exchange.getResponseHeaders();
                String connection = responseHeaders.getFirst(Headers.CONNECTION);
                boolean stillPersistent = requestLooksPersistent && exchange.isPersistent() && (connection == null || !HttpString.tryFromString(connection).equals(Headers.CLOSE));
                HttpString transferEncoding = Headers.IDENTITY;
                String transferEncodingHeader = responseHeaders.getLast(Headers.TRANSFER_ENCODING);
                String contentLengthHeader = responseHeaders.getFirst(Headers.CONTENT_LENGTH);
                if (transferEncodingHeader != null) {
                    if (exchange.isHttp11()) {
                        transferEncoding = new HttpString(transferEncodingHeader);
                    } else {
                        responseHeaders.remove(Headers.TRANSFER_ENCODING);
                    }
                } else if (exchange.isHttp11() && contentLengthHeader == null) {
                    responseHeaders.put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
                    transferEncoding = Headers.CHUNKED;
                }
                int code = exchange.getResponseCode();
                if (exchange.getRequestMethod().equals(Methods.HEAD) || 100 <= code && code <= 199 || code == 204 || code == 304) {
                    ConduitListener finishListener;
                    ConduitListener conduitListener = finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                    if (code == 101 && contentLengthHeader != null) {
                        try {
                            long contentLength = Long.parseLong(contentLengthHeader);
                            wrappedConduit = new FixedLengthStreamSinkConduit(channel, contentLength, true, !stillPersistent, finishListener);
                        }
                        catch (NumberFormatException e) {
                            stillPersistent = false;
                            wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                        }
                    } else {
                        wrappedConduit = new FixedLengthStreamSinkConduit(channel, 0L, true, !stillPersistent, finishListener);
                    }
                } else if (!transferEncoding.equals(Headers.IDENTITY)) {
                    ConduitListener finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                    wrappedConduit = new ChunkedStreamSinkConduit(channel, true, !stillPersistent, finishListener, exchange);
                } else if (contentLengthHeader != null) {
                    try {
                        long contentLength = Long.parseLong(contentLengthHeader);
                        ConduitListener finishListener = stillPersistent ? HttpTransferEncoding.terminateResponseListener(exchange) : null;
                        wrappedConduit = new FixedLengthStreamSinkConduit(channel, contentLength, true, !stillPersistent, finishListener);
                    }
                    catch (NumberFormatException e) {
                        stillPersistent = false;
                        wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                    }
                } else {
                    log.trace((Object)"Cancelling persistence because response is identity with no content length");
                    stillPersistent = false;
                    wrappedConduit = new FinishableStreamSinkConduit(channel, HttpTransferEncoding.terminateResponseListener(exchange));
                }
                if (code != 101) {
                    if (exchange.isHttp11()) {
                        if (stillPersistent) {
                            responseHeaders.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
                        } else {
                            responseHeaders.put(Headers.CONNECTION, Headers.CLOSE.toString());
                        }
                    } else if (exchange.isHttp10()) {
                        if (stillPersistent) {
                            responseHeaders.put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
                        } else {
                            responseHeaders.remove(Headers.CONNECTION);
                        }
                    }
                }
                return wrappedConduit;
            }
        };
    }

    private static StreamSourceConduit fixedLengthStreamSourceConduitWrapper(long contentLength, StreamSourceConduit conduit, HttpServerExchange exchange) {
        return new FixedLengthStreamSourceConduit(conduit, contentLength, HttpTransferEncoding.fixedLengthDrainListener(exchange), exchange);
    }

    private static ConduitListener<FixedLengthStreamSourceConduit> fixedLengthDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<FixedLengthStreamSourceConduit>(){

            @Override
            public void handleEvent(FixedLengthStreamSourceConduit fixedLengthConduit) {
                long remaining = fixedLengthConduit.getRemaining();
                if (remaining > 0L) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                exchange.terminateRequest();
            }
        };
    }

    private static ConduitListener<ChunkedStreamSourceConduit> chunkedDrainListener(final HttpServerExchange exchange) {
        return new ConduitListener<ChunkedStreamSourceConduit>(){

            @Override
            public void handleEvent(ChunkedStreamSourceConduit chunkedStreamSourceConduit) {
                if (!chunkedStreamSourceConduit.isFinished()) {
                    UndertowLogger.REQUEST_LOGGER.requestWasNotFullyConsumed();
                    exchange.setPersistent(false);
                }
                exchange.terminateRequest();
            }
        };
    }

    private static ConduitListener<StreamSinkConduit> terminateResponseListener(final HttpServerExchange exchange) {
        return new ConduitListener<StreamSinkConduit>(){

            @Override
            public void handleEvent(StreamSinkConduit channel) {
                exchange.terminateResponse();
            }
        };
    }
}

