/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.blocking;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Methods;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleBlockingServerTestCase {
    private static volatile String message;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (exchange.getRequestMethod().equals(Methods.POST)) {
                        byte[] buffer = new byte[1024];
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        int r = 0;
                        OutputStream outputStream = exchange.getOutputStream();
                        InputStream inputStream = exchange.getInputStream();
                        while ((r = inputStream.read(buffer)) > 0) {
                            b.write(buffer, 0, r);
                        }
                        outputStream.write(b.toByteArray());
                        outputStream.close();
                    } else if (exchange.getQueryParameters().containsKey("useFragmentedSender")) {
                        exchange.getResponseSender().send("", new IoCallback(){
                            int i = 0;

                            public void onComplete(HttpServerExchange exchange, Sender sender) {
                                if (this.i == message.length()) {
                                    sender.close();
                                    exchange.endExchange();
                                } else {
                                    sender.send("" + message.charAt(this.i++), (IoCallback)this);
                                }
                            }

                            public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                exchange.endExchange();
                            }
                        });
                    } else if (exchange.getQueryParameters().containsKey("useSender")) {
                        exchange.getResponseSender().send(message, IoCallback.END_EXCHANGE);
                    } else {
                        OutputStream outputStream = exchange.getOutputStream();
                        outputStream.write(message.getBytes());
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpRequest() throws IOException {
        message = "My HTTP Request!";
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadRequests() throws IOException {
        message = "My HTTP Request!";
        TestHttpClient client = new TestHttpClient();
        HttpHead head = new HttpHead(DefaultServer.getDefaultServerURL() + "/path");
        try {
            for (int i = 0; i < 3; ++i) {
                HttpResponse result = client.execute((HttpUriRequest)head);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)"", (Object)HttpClientUtils.readResponse(result));
                Assert.assertEquals((Object)(message.length() + ""), (Object)result.getFirstHeader("Content-Length").getValue());
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRequests() throws IOException {
        message = "My HTTP Request!";
        TestHttpClient client = new TestHttpClient();
        HttpDelete delete = new HttpDelete(DefaultServer.getDefaultServerURL() + "/path");
        try {
            for (int i = 0; i < 3; ++i) {
                HttpResponse result = client.execute((HttpUriRequest)delete);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeResponse() throws IOException {
        StringBuilder messageBuilder = new StringBuilder(6919638);
        for (int i = 0; i < 6919638; ++i) {
            messageBuilder.append("*");
        }
        message = messageBuilder.toString();
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)message.equals(HttpClientUtils.readResponse(result)));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?useSender");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String resultBody = HttpClientUtils.readResponse(result);
            Assert.assertTrue((boolean)message.equals(resultBody));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?useFragmentedSender");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            resultBody = HttpClientUtils.readResponse(result);
            Assert.assertTrue((boolean)message.equals(resultBody));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallRequest() throws IOException {
        message = null;
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setEntity((HttpEntity)new StringEntity("a"));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)"a".equals(HttpClientUtils.readResponse(result)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeRequest() throws IOException {
        message = null;
        StringBuilder messageBuilder = new StringBuilder(6919638);
        for (int i = 0; i < 6919638; ++i) {
            messageBuilder.append("+");
        }
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setEntity((HttpEntity)new StringEntity(messageBuilder.toString()));
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)messageBuilder.toString().equals(HttpClientUtils.readResponse(result)));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

