/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.conduits.ChunkedStreamSinkConduit;
import io.undertow.conduits.ChunkedStreamSourceConduit;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.StreamSourceConduit;

public final class ProxyHandler
implements HttpHandler {
    private final ProxyClientProvider clientProvider;
    private final int maxRequestTime;
    private static final AttachmentKey<HttpServerExchange> EXCHANGE = AttachmentKey.create(HttpServerExchange.class);
    private static final AttachmentKey<XnioExecutor.Key> TIMEOUT_KEY = AttachmentKey.create(XnioExecutor.Key.class);
    private final HttpHandler proxyClientHandler = new HttpHandler(){

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            ServerConnection serverConnection = exchange.getConnection();
            ClientConnection clientConnection = exchange.getAttachment(ProxyClient.CONNECTION);
            if (clientConnection != null) {
                exchange.dispatch(SameThreadExecutor.INSTANCE, new ProxyAction(clientConnection, exchange));
                return;
            }
            Throwable error = serverConnection.getAttachment(ProxyClient.THROWABLE);
            if (error != null) {
                if (error instanceof Exception) {
                    throw (Exception)error;
                }
                throw new RuntimeException(error);
            }
            exchange.setResponseCode(500);
        }
    };
    private final HttpHandler proxyClientProviderHandler = new HttpHandler(){

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            ProxyClient proxyClient = exchange.getAttachment(ProxyClientProvider.CLIENT);
            if (proxyClient != null) {
                proxyClient.getConnection(exchange, ProxyHandler.this.proxyClientHandler, -1L, TimeUnit.MILLISECONDS);
                return;
            }
            Throwable error = exchange.getAttachment(ProxyClientProvider.THROWABLE);
            if (error != null) {
                if (error instanceof Exception) {
                    throw (Exception)error;
                }
                throw new RuntimeException(error);
            }
            exchange.setResponseCode(500);
        }
    };

    public ProxyHandler(ProxyClientProvider clientProvider, int maxRequestTime) {
        this.clientProvider = clientProvider;
        this.maxRequestTime = maxRequestTime;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        if (this.maxRequestTime > 0) {
            final XnioExecutor.Key key = exchange.getIoThread().executeAfter(new Runnable(){

                @Override
                public void run() {
                    UndertowLogger.REQUEST_LOGGER.proxyRequestTimedOut(exchange.getRequestURI());
                    IoUtils.safeClose((Closeable)((Object)exchange.getConnection()));
                    ClientConnection clientConnection = exchange.getAttachment(ProxyClient.CONNECTION);
                    IoUtils.safeClose((Closeable)clientConnection);
                }
            }, (long)this.maxRequestTime, TimeUnit.MILLISECONDS);
            exchange.putAttachment(TIMEOUT_KEY, key);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    key.remove();
                    nextListener.proceed();
                }
            });
        }
        this.clientProvider.createProxyClient(exchange, this.proxyClientProviderHandler, -1L, TimeUnit.MILLISECONDS);
    }

    static void copyHeaders(HeaderMap to, HeaderMap from) {
        long f = from.fastIterateNonEmpty();
        while (f != -1L) {
            HeaderValues values = from.fiCurrent(f);
            to.putAll(values.getHeaderName(), values);
            f = from.fiNextNonEmpty(f);
        }
    }

    private static final class IoExceptionHandler
    implements ChannelExceptionHandler<Channel> {
        private final HttpServerExchange exchange;
        private final ClientConnection clientConnection;

        private IoExceptionHandler(HttpServerExchange exchange, ClientConnection clientConnection) {
            this.exchange = exchange;
            this.clientConnection = clientConnection;
        }

        public void handleException(Channel channel, IOException exception) {
            IoUtils.safeClose((Closeable)this.clientConnection);
            if (!this.exchange.isResponseStarted()) {
                this.exchange.setResponseCode(500);
            }
            this.exchange.setPersistent(false);
            this.exchange.endExchange();
        }
    }

    private static final class HTTPTrailerChannelListener
    implements ChannelListener<StreamSinkChannel> {
        private final Attachable source;
        private final Attachable target;

        private HTTPTrailerChannelListener(Attachable source, Attachable target) {
            this.source = source;
            this.target = target;
        }

        public void handleEvent(StreamSinkChannel channel) {
            HeaderMap trailers = this.source.getAttachment(ChunkedStreamSourceConduit.TRAILERS);
            if (trailers != null) {
                this.target.putAttachment(ChunkedStreamSinkConduit.TRAILERS, trailers);
            }
            try {
                channel.shutdownWrites();
                if (!channel.flush()) {
                    channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeWrites();
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    private static class ProxyAction
    implements Runnable {
        private final ClientConnection clientConnection;
        private final HttpServerExchange exchange;

        public ProxyAction(ClientConnection clientConnection, HttpServerExchange exchange) {
            this.clientConnection = clientConnection;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            ClientRequest request = new ClientRequest();
            String requestURI = this.exchange.getRequestURI();
            String qs = this.exchange.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                requestURI = requestURI + "?" + qs;
            }
            request.setPath(requestURI).setMethod(this.exchange.getRequestMethod());
            HeaderMap inboundRequestHeaders = this.exchange.getRequestHeaders();
            HeaderMap outboundRequestHeaders = request.getRequestHeaders();
            ProxyHandler.copyHeaders(outboundRequestHeaders, inboundRequestHeaders);
            this.clientConnection.sendRequest(request, new ClientCallback<ClientExchange>(){

                @Override
                public void completed(ClientExchange result) {
                    result.putAttachment(EXCHANGE, ProxyAction.this.exchange);
                    if (HttpContinue.requiresContinueResponse(ProxyAction.this.exchange)) {
                        result.setContinueHandler(new ContinueNotification(){

                            @Override
                            public void handleContinue(ClientExchange clientExchange) {
                                HttpContinue.sendContinueResponse(ProxyAction.this.exchange, new IoCallback(){

                                    @Override
                                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                                    }

                                    @Override
                                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                                        IoUtils.safeClose((Closeable)ProxyAction.this.clientConnection);
                                    }
                                });
                            }
                        });
                    }
                    result.setResponseListener(new ResponseCallback(ProxyAction.this.exchange));
                    IoExceptionHandler handler = new IoExceptionHandler(ProxyAction.this.exchange, ProxyAction.this.clientConnection);
                    ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)ProxyAction.this.exchange.getRequestChannel(), (StreamSinkChannel)result.getRequestChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(ProxyAction.this.exchange, result), (ChannelExceptionHandler)handler, (ChannelExceptionHandler)handler, ProxyAction.this.exchange.getConnection().getBufferPool());
                }

                @Override
                public void failed(IOException e) {
                    ProxyAction.this.exchange.setResponseCode(500);
                    ProxyAction.this.exchange.setPersistent(false);
                    ProxyAction.this.exchange.endExchange();
                }
            });
        }
    }

    private static final class ResponseCallback
    implements ClientCallback<ClientExchange> {
        private final HttpServerExchange exchange;

        private ResponseCallback(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientExchange result) {
            HttpServerExchange exchange = (HttpServerExchange)result.getAttachment(EXCHANGE);
            ClientResponse response = result.getResponse();
            HeaderMap inboundResponseHeaders = response.getResponseHeaders();
            HeaderMap outboundResponseHeaders = exchange.getResponseHeaders();
            exchange.setResponseCode(response.getResponseCode());
            ProxyHandler.copyHeaders(outboundResponseHeaders, inboundResponseHeaders);
            if (exchange.isUpgrade()) {
                exchange.upgradeChannel(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        StreamConnection clientChannel = null;
                        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
                        try {
                            clientChannel = result.getConnection().performUpgrade();
                            connection.resetChannel();
                            StreamConnection streamConnection = connection.getChannel();
                            if (connection.getExtraBytes() != null) {
                                streamConnection.getSourceChannel().setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(streamConnection.getSourceChannel().getConduit(), connection));
                            }
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)clientChannel.getSourceChannel(), (StreamSinkChannel)streamConnection.getSinkChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)streamConnection.getSourceChannel(), (StreamSinkChannel)clientChannel.getSinkChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)ChannelListeners.writeShutdownChannelListener((ChannelListener)ChannelListeners.flushingChannelListener((ChannelListener)ChannelListeners.closingChannelListener(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler(), connection.getBufferPool());
                            nextListener.proceed();
                        }
                        catch (IOException e) {
                            IoUtils.safeClose((Closeable)connection.getChannel());
                        }
                    }
                });
            }
            IoExceptionHandler handler = new IoExceptionHandler(exchange, result.getConnection());
            ChannelListeners.initiateTransfer((long)Long.MAX_VALUE, (StreamSourceChannel)result.getResponseChannel(), (StreamSinkChannel)exchange.getResponseChannel(), (ChannelListener)ChannelListeners.closingChannelListener(), (ChannelListener)new HTTPTrailerChannelListener(result, exchange), (ChannelExceptionHandler)handler, (ChannelExceptionHandler)handler, exchange.getConnection().getBufferPool());
        }

        @Override
        public void failed(IOException e) {
            this.exchange.setResponseCode(500);
            this.exchange.endExchange();
        }
    }
}

