/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.PathMatchPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class PredicateParsingTestCase {
    @Test
    public void testPredicateParser() {
        Predicate predicate = PredicateParser.parse((String)"path[foo]", (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
        Assert.assertTrue((boolean)(predicate instanceof PathMatchPredicate));
        HttpServerExchange e = new HttpServerExchange(null);
        e.setRelativePath("/foo");
        Assert.assertTrue((boolean)predicate.resolve(e));
        e.setRelativePath("/bob");
        Assert.assertFalse((boolean)predicate.resolve(e));
        for (String string : new String[]{"not path[\"/foo\"]", "not path[foo] and true", "false or not path[path=/foo]", "false or not path[/foo]", "true and not path[foo] or not path[foo] and false"}) {
            try {
                predicate = PredicateParser.parse((String)string, (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
                e = new HttpServerExchange(null);
                e.setRelativePath("/foo");
                Assert.assertFalse((boolean)predicate.resolve(e));
                e.setRelativePath("/bob");
                Assert.assertTrue((boolean)predicate.resolve(e));
            }
            catch (Throwable ex) {
                throw new RuntimeException("String " + string, ex);
            }
        }
    }

    @Test
    public void testRegularExpressionsWithPredicateContext() {
        Predicate predicate = PredicateParser.parse((String)"regex[pattern=a* , value=%{RELATIVE_PATH}] and equals[{$0, aaa}]", (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
        HttpServerExchange e = new HttpServerExchange(null);
        e.putAttachment(Predicate.PREDICATE_CONTEXT, new HashMap());
        e.setRelativePath("aaab");
        Assert.assertTrue((boolean)predicate.resolve(e));
        e.setRelativePath("aaaab");
        Assert.assertFalse((boolean)predicate.resolve(e));
        predicate = PredicateParser.parse((String)"regex[pattern='a(b*)a*' , value=%{RELATIVE_PATH}] and equals[$1, bb]", (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
        e.putAttachment(Predicate.PREDICATE_CONTEXT, new HashMap());
        e.setRelativePath("abb");
        Assert.assertTrue((boolean)predicate.resolve(e));
        e.setRelativePath("abbaaa");
        Assert.assertTrue((boolean)predicate.resolve(e));
        e.setRelativePath("abbb");
        Assert.assertFalse((boolean)predicate.resolve(e));
    }

    @Test
    public void testArrayValues() {
        for (String string : new String[]{"contains[value=%{i,Content-Type}, search=text]", "contains[value=\"%{i,Content-Type}\", search={text}]", "contains[value=\"%{i,Content-Type}\", search={text, \"other text\"}]"}) {
            try {
                Predicate predicate = PredicateParser.parse((String)string, (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
                HttpServerExchange e = new HttpServerExchange(null);
                Assert.assertFalse((boolean)predicate.resolve(e));
                e.getRequestHeaders().add(Headers.CONTENT_TYPE, "text");
                Assert.assertTrue((boolean)predicate.resolve(e));
            }
            catch (Throwable ex) {
                throw new RuntimeException("String " + string, ex);
            }
        }
    }

    @Test
    public void testOrderOfOperations() {
        this.expect("exists[%{i,Content-Length}] or exists[value=%{i,Trailer}] and exists[%{i,Other}]", false, true);
        this.expect("(exists[%{i,Content-Length}] or exists[value=%{i,Trailer}]) and exists[%{i,Other}]", false, false);
    }

    private void expect(String string, boolean result1, boolean result2) {
        try {
            Predicate predicate = PredicateParser.parse((String)string, (ClassLoader)PredicateParsingTestCase.class.getClassLoader());
            HttpServerExchange e = new HttpServerExchange(null);
            e.getRequestHeaders().add(Headers.TRAILER, "a");
            Assert.assertEquals((Object)result1, (Object)predicate.resolve(e));
            e.getRequestHeaders().add(Headers.CONTENT_LENGTH, "a");
            Assert.assertEquals((Object)result2, (Object)predicate.resolve(e));
        }
        catch (Throwable ex) {
            throw new RuntimeException("String " + string, ex);
        }
    }
}

