/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.PathTemplate;
import java.util.HashMap;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;

public class PathTemplateTestCase {
    @Test
    public void testMatches() {
        this.testMatch("/docs/mydoc", "/docs/mydoc", new String[0]);
        this.testMatch("/docs/{docId}", "/docs/mydoc", "docId", "mydoc");
        this.testMatch("/docs/{docId}/{op}", "/docs/mydoc/read", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/{op}/{allowed}", "/docs/mydoc/read/true", "docId", "mydoc", "op", "read", "allowed", "true");
        this.testMatch("/docs/{docId}/operation/{op}", "/docs/mydoc/operation/read", "docId", "mydoc", "op", "read");
        this.testMatch("/docs/{docId}/read", "/docs/mydoc/read", "docId", "mydoc");
        this.testMatch("/docs/{docId}/read", "/docs/mydoc/read?myQueryParam", "docId", "mydoc");
        this.testMatch("/{foo}", "/bob", "foo", "bob");
    }

    @Test
    public void testDetectDuplicates() {
        TreeSet<PathTemplate> seen = new TreeSet<PathTemplate>();
        seen.add(PathTemplate.create((String)"/bob/{foo}"));
        Assert.assertTrue((boolean)seen.contains(PathTemplate.create((String)"/bob/{ak}")));
        Assert.assertFalse((boolean)seen.contains(PathTemplate.create((String)"/bob/{ak}/other")));
    }

    private void testMatch(String template, String path, String ... pathParams) {
        Assert.assertEquals((long)0L, (long)(pathParams.length % 2));
        HashMap<String, String> expected = new HashMap<String, String>();
        for (int i = 0; i < pathParams.length; i += 2) {
            expected.put(pathParams[i], pathParams[i + 1]);
        }
        HashMap params = new HashMap();
        PathTemplate pathTemplate = PathTemplate.create((String)template);
        Assert.assertTrue((String)("Failed. Template: " + pathTemplate), (boolean)pathTemplate.matches(path, params));
        Assert.assertEquals(expected, params);
    }
}

