/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import io.undertow.util.StringWriteChannelListener;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class PreChunkedResponseTransferCodingTestCase {
    private static final String MESSAGE = "My HTTP Request!";
    private static volatile String message;
    private static volatile String chunkedMessage;
    private static volatile ServerConnection connection;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (connection == null) {
                        connection = exchange.getConnection();
                    } else if (!DefaultServer.isAjp() && !DefaultServer.isProxy() && connection != exchange.getConnection()) {
                        OutputStream outputStream = exchange.getOutputStream();
                        outputStream.write("Connection not persistent".getBytes());
                        outputStream.close();
                        return;
                    }
                    exchange.getResponseHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
                    exchange.putAttachment(HttpAttachments.PRE_CHUNKED_RESPONSE, (Object)true);
                    new StringWriteChannelListener(chunkedMessage).setup(exchange.getResponseChannel());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendHttpRequest() throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
        TestHttpClient client = new TestHttpClient();
        try {
            PreChunkedResponseTransferCodingTestCase.generateMessage(0);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            PreChunkedResponseTransferCodingTestCase.generateMessage(1);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
            PreChunkedResponseTransferCodingTestCase.generateMessage(1000);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)message, (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static void generateMessage(int repetitions) {
        StringBuilder builder = new StringBuilder(repetitions * MESSAGE.length());
        StringBuilder chunkedBuilder = new StringBuilder(repetitions * MESSAGE.length());
        for (int i = 0; i < repetitions; ++i) {
            builder.append(MESSAGE);
            chunkedBuilder.append(Integer.toHexString(MESSAGE.length()));
            chunkedBuilder.append("\r\n");
            chunkedBuilder.append(MESSAGE);
            chunkedBuilder.append("\r\n");
        }
        chunkedBuilder.append("0\r\n\r\n");
        message = builder.toString();
        chunkedMessage = chunkedBuilder.toString();
    }
}

