/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class WriteTimeoutStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private XnioExecutor.Key handle;
    private final StreamConnection connection;
    private static final int FUZZ_FACTOR = 50;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", new Object[0]);
            IoUtils.safeClose((Closeable)WriteTimeoutStreamSinkConduit.this.connection);
            if (WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel().isReadResumed()) {
                ChannelListeners.invokeChannelListener((Channel)WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel(), (ChannelListener)WriteTimeoutStreamSinkConduit.this.connection.getSourceChannel().getReadListener());
            }
            if (WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel().isWriteResumed()) {
                ChannelListeners.invokeChannelListener((Channel)WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel(), (ChannelListener)WriteTimeoutStreamSinkConduit.this.connection.getSinkChannel().getWriteListener());
            }
        }
    };

    public WriteTimeoutStreamSinkConduit(StreamSinkConduit delegate, StreamConnection connection) {
        super(delegate);
        this.connection = connection;
    }

    private void handleWriteTimeout(long ret) throws IOException {
        Integer writeTimout = (Integer)this.connection.getOption(Options.WRITE_TIMEOUT);
        if (writeTimout != null && writeTimout > 0) {
            if (ret == 0L && this.handle == null) {
                this.handle = super.getWriteThread().executeAfter(this.timeoutCommand, (long)(writeTimout + 50), TimeUnit.MILLISECONDS);
            } else if (ret > 0L && this.handle != null) {
                this.handle.remove();
            }
        }
    }

    public int write(ByteBuffer src) throws IOException {
        int ret = super.write(src);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = super.write(srcs, offset, length);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        int ret = super.writeFinal(src);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = super.writeFinal(srcs, offset, length);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long ret = super.transferFrom(src, position, count);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long ret = super.transferFrom(source, count, throughBuffer);
        this.handleWriteTimeout(ret);
        return ret;
    }

    public void awaitWritable() throws IOException {
        Integer timeout = (Integer)this.connection.getOption(Options.WRITE_TIMEOUT);
        if (timeout != null && timeout > 0) {
            super.awaitWritable((long)(timeout + 50), TimeUnit.MILLISECONDS);
        } else {
            super.awaitWritable();
        }
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        Integer timeout = (Integer)this.connection.getOption(Options.WRITE_TIMEOUT);
        if (timeout != null && timeout > 0) {
            long millis = timeUnit.toMillis(time);
            super.awaitWritable(Math.min(millis, (long)(timeout + 50)), TimeUnit.MILLISECONDS);
        } else {
            super.awaitWritable(time, timeUnit);
        }
    }
}

