/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Deque;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true)
public class LotsOfQueryParametersTestCase {
    private static final String HEADER = "HEADER";
    private static final String MESSAGE = "Hello Header";
    private static final int COUNT = 200;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                for (Map.Entry entry : exchange.getQueryParameters().entrySet()) {
                    exchange.getResponseHeaders().put(HttpString.tryFromString((String)((String)entry.getKey())), (String)((Deque)entry.getValue()).getFirst());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLotsOfQueryParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            StringBuilder qs = new StringBuilder();
            for (int i = 0; i < 200; ++i) {
                qs.append(HEADER + i);
                qs.append("=");
                qs.append(URLEncoder.encode(MESSAGE + i, "UTF-8"));
                qs.append("&");
            }
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path?" + qs.toString());
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            for (int i = 0; i < 200; ++i) {
                Header[] header = result.getHeaders(HEADER + i);
                Assert.assertEquals((Object)(MESSAGE + i), (Object)header[0].getValue());
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

