/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class QueryParametersTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                Iterator iterator = exchange.getQueryParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry qp = iterator.next();
                    sb.append((String)qp.getKey());
                    sb.append("=>");
                    if (((Deque)qp.getValue()).size() == 1) {
                        sb.append((String)((Deque)qp.getValue()).getFirst());
                    } else {
                        sb.append("[");
                        Iterator i = ((Deque)qp.getValue()).iterator();
                        while (i.hasNext()) {
                            String val = (String)i.next();
                            sb.append(val);
                            if (!i.hasNext()) continue;
                            sb.append(",");
                        }
                        sb.append("]");
                    }
                    if (!iterator.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("}");
                exchange.getResponseSender().send(sb.toString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryParameters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "{unicode=>I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0li\u017e\u00e6ti\u00f8n}", "/path?unicode=I\u00f1t\u00ebrn\u00e2ti\u00f4n\u00e0li\u017e\u00e6ti\u00f8n");
            this.runTest(client, "{a=>b,value=>bb bb}", "/path?a=b&value=bb%20bb");
            this.runTest(client, "{a=>b,value=>[bb,cc]}", "/path?a=b&value=bb&value=cc");
            this.runTest(client, "{a=>b,s =>,t =>,value=>[bb,cc]}", "/path?a=b&value=bb&value=cc&s%20&t%20");
            this.runTest(client, "{a=>b,s =>,t =>,value=>[bb,cc]}", "/path?a=b&value=bb&value=cc&s%20&t%20&");
            this.runTest(client, "{a=>b,s =>,t =>,u=>,value=>[bb,cc]}", "/path?a=b&value=bb&value=cc&s%20&t%20&u");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(TestHttpClient client, String expected, String queryString) throws IOException {
        Assert.assertEquals((Object)expected, (Object)HttpClientUtils.readResponse(client.execute((HttpUriRequest)new HttpGet(DefaultServer.getDefaultServerURL() + queryString))));
    }
}

