/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RedirectTestCase {
    private static volatile String message;

    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler((HttpHandler)new PathHandler().addPrefixPath("/target", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                message = exchange.getRequestURI();
            }
        }).addPrefixPath("/", Handlers.predicateContext((HttpHandler)Handlers.predicate((Predicate)Predicates.regex((String)"%{REQUEST_URL}", (String)"/(aa.*?)c", (ClassLoader)RedirectTestCase.class.getClassLoader(), (boolean)false), (HttpHandler)Handlers.redirect((String)"/target/matched/${1}"), (HttpHandler)Handlers.redirect((String)"/target%U")))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedirectHandler() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/a");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"/target/path/a", (Object)message);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/aabc");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"/target/matched/aab", (Object)message);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somePath/aabc");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"/target/matched/aab", (Object)message);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

