/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.FileUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.MultipartParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Pool;

public class MimeDecodingTestCase {
    final ByteBufferSlicePool bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 512, 3072);

    @Test
    public void testSimpleMimeDecodingWithPreamble() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime1.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)this.bufferPool, (MultipartParser.PartHandler)handler, (byte[])"unique-boundary-1".getBytes(), (String)"ISO-8859-1");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)2L, (long)handler.parts.size());
        Assert.assertEquals((Object)"Here is some text.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"Here is some more text.", (Object)((Part)handler.parts.get(1)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
    }

    @Test
    public void testMimeDecodingWithUTF8Headers() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime-utf8.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)this.bufferPool, (MultipartParser.PartHandler)handler, (byte[])"unique-boundary-1".getBytes(), (String)"UTF-8");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)1L, (long)handler.parts.size());
        Assert.assertEquals((Object)"Just some chinese characters I copied from the internet, no idea what it says.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
        Assert.assertEquals((Object)"attachment; filename=\u4e2a\u4e13\u4e3a\u8bed\u6587\u6559\u5b66\u800c\u8bbe\u8ba1\u7684\u7535\u8111\u8f6f\u4ef6.txt", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_DISPOSITION));
    }

    @Test
    public void testSimpleMimeDecodingWithoutPreamble() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime2.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)this.bufferPool, (MultipartParser.PartHandler)handler, (byte[])"unique-boundary-1".getBytes(), (String)"ISO-8859-1");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)2L, (long)handler.parts.size());
        Assert.assertEquals((Object)"Here is some text.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"Here is some more text.", (Object)((Part)handler.parts.get(1)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
    }

    @Test
    public void testBase64MimeDecoding() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime3.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)this.bufferPool, (MultipartParser.PartHandler)handler, (byte[])"unique-boundary-1".getBytes(), (String)"ISO-8859-1");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)2L, (long)handler.parts.size());
        Assert.assertEquals((Object)"This is some base64 text.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"This is some more base64 text.", (Object)((Part)handler.parts.get(1)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
    }

    @Test
    public void testBase64MimeDecodingWithSmallBuffers() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime3.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 6, 36), (MultipartParser.PartHandler)handler, (byte[])"unique-boundary-1".getBytes(), (String)"ISO-8859-1");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)2L, (long)handler.parts.size());
        Assert.assertEquals((Object)"This is some base64 text.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"This is some more base64 text.", (Object)((Part)handler.parts.get(1)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
    }

    @Test
    public void testQuotedPrintable() throws IOException {
        String data = MimeDecodingTestCase.fixLineEndings(FileUtils.readFile(MimeDecodingTestCase.class, (String)"mime4.txt"));
        TestPartHandler handler = new TestPartHandler();
        MultipartParser.ParseState parser = MultipartParser.beginParse((Pool)this.bufferPool, (MultipartParser.PartHandler)handler, (byte[])"someboundarytext".getBytes(), (String)"ISO-8859-1");
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        parser.parse(buf);
        Assert.assertTrue((boolean)parser.isComplete());
        Assert.assertEquals((long)1L, (long)handler.parts.size());
        Assert.assertEquals((Object)"time=money.", (Object)((Part)handler.parts.get(0)).data.toString());
        Assert.assertEquals((Object)"text/plain", (Object)((Part)handler.parts.get(0)).map.getFirst(Headers.CONTENT_TYPE));
    }

    private static String fixLineEndings(String string) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                if (i == 0 || string.charAt(i - 1) != '\r') {
                    builder.append("\r\n");
                    continue;
                }
                builder.append('\n');
                continue;
            }
            if (c == '\r') {
                if (i + 1 == string.length() || string.charAt(i + 1) != '\n') {
                    builder.append("\r\n");
                    continue;
                }
                builder.append('\r');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static class Part {
        private final HeaderMap map;
        private final StringBuilder data = new StringBuilder();

        private Part(HeaderMap map) {
            this.map = map;
        }
    }

    private static class TestPartHandler
    implements MultipartParser.PartHandler {
        private final List<Part> parts = new ArrayList<Part>();
        private Part current;

        private TestPartHandler() {
        }

        public void beginPart(HeaderMap headers) {
            this.current = new Part(headers);
            this.parts.add(this.current);
        }

        public void data(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                this.current.data.append((char)buffer.get());
            }
        }

        public void endPart() {
        }
    }
}

